/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.List;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.Cleaner;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;
import uk.ac.warwick.util.core.HtmlUtils;

public final class BodyCleanupHtmlTransformer
implements TextTransformer {
    private final Cleaner cleaner;

    public BodyCleanupHtmlTransformer(Cleaner theCleaner) {
        this.cleaner = theCleaner;
    }

    public MutableContent apply(MutableContent mc) {
        String result;
        String text = mc.getContent();
        List bodies = HtmlUtils.extractContent((String)text, (String)"<body", (String)"</body>");
        if (bodies.size() > 0) {
            String body = (String)bodies.iterator().next();
            body = this.cleaner.clean(body, mc);
            result = HtmlUtils.replaceContent((String)text, (String)("\n\n" + body + "\n"), (String)"<body", (String)"</body>");
        } else {
            result = this.cleaner.clean(text, mc);
        }
        mc.setContent(result);
        return mc;
    }
}

