/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jsoup.nodes.Element;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public class BadLinkRemovingTransformer
implements TextTransformer {
    private static String[] BANNED_HREF_PROTOCOLS = new String[]{"javascript"};
    private static String[] BANNED_SRC_PROTOCOLS = new String[]{"javascript"};

    public MutableContent apply(MutableContent mc) {
        boolean changed = this.sanitiseAttributes(mc, "href", BANNED_HREF_PROTOCOLS);
        if (changed |= this.sanitiseAttributes(mc, "src", BANNED_SRC_PROTOCOLS)) {
            mc.documentChanged();
        }
        return mc;
    }

    private boolean sanitiseAttributes(MutableContent mc, String attributeToCheck, String[] bannedSchemes) {
        boolean changed = false;
        for (Element el : mc.getDocument().select("[" + attributeToCheck + "]")) {
            boolean allowAttribute;
            boolean parseError = false;
            try {
                String attrValue = el.attr(attributeToCheck);
                URI uri = this.getValidUri(attrValue);
                allowAttribute = Arrays.stream(bannedSchemes).noneMatch(a -> uri.getScheme() != null && uri.getScheme().equalsIgnoreCase((String)a));
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                allowAttribute = false;
                parseError = true;
            }
            if (allowAttribute) continue;
            el.removeAttr(attributeToCheck);
            el.attr("data-error", !parseError ? "Stripped " + attributeToCheck + " due to banned scheme" : "Failed to parse URI");
            changed = true;
        }
        return changed;
    }

    private URI getValidUri(String attrValue) throws URISyntaxException, UnsupportedEncodingException {
        String[] alwaysUnsafe;
        for (String replacement : alwaysUnsafe = new String[]{"^", "|", "\\", "\"", " ", "{", "}"}) {
            attrValue = attrValue.replace(replacement, URLEncoder.encode(replacement, StandardCharsets.UTF_8.name()));
        }
        attrValue = attrValue.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
        return new URI(attrValue);
    }
}

