/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.texttransformers.AbstractMagicTagTransformer;
import uk.ac.warwick.util.core.StringUtils;

public abstract class AbstractSquareTagTransformer
extends AbstractMagicTagTransformer {
    private static final int TAGNAME_MATCH_GROUP = 1;
    private static final int PARAMETERS_MATCH_GROUP = 2;
    private static final int CONTENTS_MATCH_GROUP = 3;
    private static final int BLOCKLEVEL_STANDARD_TAGNAME_MATCH_GROUP = 2;
    private static final int BLOCKLEVEL_STANDARD_PARAMETERS_MATCH_GROUP = 3;
    private static final int BLOCKLEVEL_STANDARD_CONTENTS_MATCH_GROUP = 4;
    private static final int BLOCKLEVEL_BLOCK_TAGNAME_MATCH_GROUP = 6;
    private static final int BLOCKLEVEL_BLOCK_PARAMETERS_MATCH_GROUP = 7;
    private static final int BLOCKLEVEL_BLOCK_CONTENTS_MATCH_GROUP = 8;
    private final boolean isBlockLevel;

    public AbstractSquareTagTransformer(String theTagName) {
        this(theTagName, false);
    }

    public AbstractSquareTagTransformer(String theTagName, boolean multiline) {
        this(theTagName, multiline, false);
    }

    public AbstractSquareTagTransformer(String theTagName, boolean multiline, boolean allowEmpty) {
        this(theTagName, multiline, allowEmpty, false);
    }

    public AbstractSquareTagTransformer(String theTagName, boolean multiline, boolean allowEmpty, boolean blockLevel) {
        this(new String[]{theTagName}, multiline, allowEmpty, blockLevel);
    }

    public AbstractSquareTagTransformer(String ... theTagNames) {
        this(theTagNames, false);
    }

    public AbstractSquareTagTransformer(String[] theTagNames, boolean multiline) {
        this(theTagNames, multiline, false);
    }

    public AbstractSquareTagTransformer(String[] theTagNames, boolean multiline, boolean allowEmpty) {
        this(theTagNames, multiline, allowEmpty, false);
    }

    public AbstractSquareTagTransformer(String[] theTagNames, boolean multiline, boolean allowEmpty, boolean blockLevel) {
        super(theTagNames, AbstractSquareTagTransformer.getPatternForTagNames(theTagNames, multiline, allowEmpty, blockLevel));
        this.isBlockLevel = blockLevel;
    }

    private static Pattern getPatternForTagNames(String[] theTagNames, boolean multiline, boolean allowEmpty, boolean blockLevel) {
        int flags = 2;
        String optional = "";
        if (multiline) {
            flags |= 0x20;
        }
        if (allowEmpty) {
            optional = "?";
        }
        String pattern = "\\[(" + StringUtils.join((String[])theTagNames, (String)"|") + ")(\\s+.+?[^\\\\])?\\](.+?)" + optional + "\\[/\\1\\]";
        if (blockLevel) {
            pattern = "(" + pattern.replace("\\1", "\\2") + ")|((?:<p>\\s*(?:&nbsp;)*\\s*)" + pattern.replace("\\1", "\\6") + "(?:\\s*(?:&nbsp;)*\\s*</p>))";
        }
        return Pattern.compile(pattern, flags);
    }

    protected final Map<String, Object> getParameters(Matcher matcher) {
        if (this.isBlockLevel) {
            Map<String, Object> result = matcher.group(1) != null ? this.extractParameters(matcher.group(3)) : this.extractParameters(matcher.group(7));
            return result;
        }
        return this.extractParameters(matcher.group(2));
    }

    protected String getTagName(Matcher matcher) {
        if (this.isBlockLevel) {
            String result = matcher.group(1) != null ? matcher.group(2) : matcher.group(6);
            return result;
        }
        return matcher.group(1);
    }

    protected final String getContents(Matcher matcher) {
        if (this.isBlockLevel) {
            String result = matcher.group(1) != null ? matcher.group(4) : "<p>" + matcher.group(8) + "</p>";
            return result;
        }
        return matcher.group(3);
    }
}

