/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.textile2;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public final class TextileTextTransformer
implements TextTransformer {
    public static final String TEXTILE_SERVICE_LOCATION_PROPERTY_KEY = "textile.service.location";
    private static String TEXTILE_SERVICE_URL = "http://localhost:2000/textile";
    private static final int CONNECTION_TIMEOUT = 3000;

    public TextileTextTransformer() {
        this.setupTextile2ServiceLocation(null);
    }

    public TextileTextTransformer(String textile2ServiceLocation) {
        this.setupTextile2ServiceLocation(textile2ServiceLocation);
    }

    private void setupTextile2ServiceLocation(String textile2ServiceLocation) {
        if (textile2ServiceLocation != null) {
            TEXTILE_SERVICE_URL = textile2ServiceLocation;
        } else if (System.getProperty(TEXTILE_SERVICE_LOCATION_PROPERTY_KEY) != null) {
            TEXTILE_SERVICE_URL = System.getProperty(TEXTILE_SERVICE_LOCATION_PROPERTY_KEY);
        }
    }

    public MutableContent apply(MutableContent mc) {
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost method = new HttpPost(TEXTILE_SERVICE_URL);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("textile", mc.getContent()));
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(3000).setSocketTimeout(3000).build();
            method.setConfig(config);
            HttpResponse response = client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IllegalStateException("Error connecting with Textile server - response code was " + response.getStatusLine().getStatusCode());
            }
            mc.setContent(EntityUtils.toString((HttpEntity)response.getEntity()).trim());
            return mc;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error connecting with Textile server - " + e.getMessage(), e);
        }
    }
}

