/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.textile2;

import java.util.EnumSet;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.content.JsoupHtmlParser;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.HtmlCleaner;
import uk.ac.warwick.util.content.textile2.Textile2;
import uk.ac.warwick.util.content.textile2.TransformationOptions;
import uk.ac.warwick.util.content.textile2.TransformerFeature;
import uk.ac.warwick.util.content.textile2.lite.TextileLite;

public class TextileString {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextileString.class);
    private String textileText;
    private boolean stripAllHtmlBeforeConvert;
    private boolean stripAllHtmlAfterConvert;
    private String disallowTags;
    private String onlyAllowTags;
    private boolean lite;
    private boolean correctHtml;
    private boolean addNoFollow;
    private boolean allowJavascriptHandlers = true;
    private boolean allowBlockquoteWithNoAttributes;
    private EnumSet<TransformerFeature> features = null;
    private EnumSet<TransformationOptions> options = null;
    private HtmlCleaner cleaner = new HtmlCleaner();
    private JsoupHtmlParser parser = new JsoupHtmlParser();

    public TextileString(String theTextileText) {
        this.textileText = theTextileText;
    }

    public final String getHtml() {
        String converted;
        if (this.isStripAllHtmlBeforeConvert()) {
            this.textileText = Pattern.compile("\\<\\S.*?\\>", 32).matcher(this.textileText).replaceAll("");
        }
        this.textileText = TextileString.stripTags(this.textileText, this.getDisallowTags());
        if (this.isLite()) {
            TextileLite textile = new TextileLite();
            converted = textile.apply(new MutableContent(this.parser, this.textileText)).getContent();
        } else {
            Textile2 textile;
            if (this.features != null) {
                if (this.isAddNoFollow() && !this.features.contains((Object)TransformerFeature.noFollowLinks)) {
                    this.features = EnumSet.copyOf(this.features);
                    this.features.add(TransformerFeature.noFollowLinks);
                }
                textile = new Textile2(this.features, this.options);
            } else {
                textile = new Textile2(this.isAddNoFollow(), this.options);
            }
            try {
                converted = textile.apply(new MutableContent(this.parser, this.textileText)).getContent();
            }
            catch (IllegalStateException e) {
                LOGGER.error("There was an error performing Textile2 conversion:" + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        converted = this.isStripAllHtmlAfterConvert() ? Pattern.compile("\\<\\S.*?\\>", 32).matcher(converted).replaceAll("") : TextileString.onlyAllowTags(converted, this.getOnlyAllowTags());
        if (this.isCorrectHtml()) {
            converted = this.correctHtml(converted);
        }
        return converted;
    }

    public static final String stripTags(String origContent, String tags) {
        String newContent = origContent;
        if (tags != null && origContent != null) {
            StringTokenizer tokenizer = new StringTokenizer(tags, ",");
            while (tokenizer.hasMoreTokens()) {
                String tagToStrip = tokenizer.nextToken();
                tagToStrip = tagToStrip.trim();
                newContent = newContent.replaceAll("(?i)\\<" + tagToStrip + ".*?\\>", "");
                newContent = newContent.replaceAll("(?i)\\</" + tagToStrip + ".*?\\>", "");
            }
        }
        return newContent;
    }

    public static final String onlyAllowTags(String origContent, String tags) {
        if (tags == null || origContent == null) {
            return origContent;
        }
        String[] individualTags = tags.split(",");
        String sep = "";
        String tagExp = "";
        for (int i = 0; i < individualTags.length; ++i) {
            String tag = individualTags[i];
            tagExp = tagExp + sep + tag;
            sep = "|";
            tagExp = tagExp + sep + "/" + tag;
        }
        String converted = origContent.replaceAll("(?i)<(?!(" + tagExp + ")(\\s.*?>|>)).*?>", "");
        return converted;
    }

    public final String correctHtml(String origContent) {
        this.cleaner.setAllowJavascriptHandlers(this.allowJavascriptHandlers);
        this.cleaner.setAllowBlockquoteWithNoAttributes(this.allowBlockquoteWithNoAttributes);
        return this.cleaner.clean(origContent, new MutableContent(this.parser, null));
    }

    public final String getTextileText() {
        return this.textileText;
    }

    public final String getDisallowTags() {
        return this.disallowTags;
    }

    public final void setDisallowTags(String disallowTags) {
        this.disallowTags = disallowTags;
    }

    public final String getOnlyAllowTags() {
        return this.onlyAllowTags;
    }

    public final void setOnlyAllowTags(String onlyAllowTags) {
        this.onlyAllowTags = onlyAllowTags;
    }

    public final boolean isStripAllHtmlAfterConvert() {
        return this.stripAllHtmlAfterConvert;
    }

    public final void setStripAllHtmlAfterConvert(boolean stripAllHtmlAfterConvert) {
        this.stripAllHtmlAfterConvert = stripAllHtmlAfterConvert;
    }

    public final boolean isStripAllHtmlBeforeConvert() {
        return this.stripAllHtmlBeforeConvert;
    }

    public final void setStripAllHtmlBeforeConvert(boolean stripAllHtmlBeforeConvert) {
        this.stripAllHtmlBeforeConvert = stripAllHtmlBeforeConvert;
    }

    public final boolean isCorrectHtml() {
        return this.correctHtml;
    }

    public final boolean isAddNoFollow() {
        return this.addNoFollow;
    }

    public final void setAddNoFollow(boolean addNoFollow) {
        this.addNoFollow = addNoFollow;
    }

    public final void setCorrectHtml(boolean correctHtml) {
        this.correctHtml = correctHtml;
    }

    public final boolean isLite() {
        return this.lite;
    }

    public final void setLite(boolean lite) {
        this.lite = lite;
    }

    public boolean isAllowJavascriptHandlers() {
        return this.allowJavascriptHandlers;
    }

    public void setAllowJavascriptHandlers(boolean allowJavascriptHandlers) {
        this.allowJavascriptHandlers = allowJavascriptHandlers;
    }

    public boolean isAllowBlockquoteWithNoAttributes() {
        return this.allowBlockquoteWithNoAttributes;
    }

    public void setAllowBlockquoteWithNoAttributes(boolean allowBlockquoteWithNoAttributes) {
        this.allowBlockquoteWithNoAttributes = allowBlockquoteWithNoAttributes;
    }

    public EnumSet<TransformerFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(EnumSet<TransformerFeature> features) {
        this.features = features;
    }

    public EnumSet<TransformationOptions> getOptions() {
        return this.options;
    }

    public void setOptions(EnumSet<TransformationOptions> options) {
        this.options = options;
    }

    public HtmlCleaner getCleaner() {
        return this.cleaner;
    }
}

