/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.freemarker;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;

public final class DateTimeFreemarkerObjectWrapper
extends DefaultObjectWrapper {
    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            Date date = Date.from(instant);
            return super.wrap((Object)date);
        }
        if (object instanceof ChronoLocalDate) {
            ChronoLocalDate instant = (ChronoLocalDate)object;
            Date date = Date.from(instant.atTime(LocalTime.MIDNIGHT).toInstant(ZoneOffset.of("Europe/London")));
            return super.wrap((Object)date);
        }
        if (object instanceof ChronoLocalDateTime) {
            ChronoLocalDateTime instant = (ChronoLocalDateTime)object;
            Date date = Date.from(instant.toInstant(ZoneOffset.of("Europe/London")));
            return super.wrap((Object)date);
        }
        if (object instanceof ChronoZonedDateTime) {
            ChronoZonedDateTime instant = (ChronoZonedDateTime)object;
            Date date = Date.from(instant.toInstant());
            return super.wrap((Object)date);
        }
        return super.wrap(object);
    }
}

