/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.cleaner;

import java.util.HashSet;
import org.ccil.cowan.tagsoup.ElementType;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.Attributes;
import uk.ac.warwick.html5.HTML5Schema;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.BodyContentFilter;
import uk.ac.warwick.util.content.cleaner.HtmlContentWriter;
import uk.ac.warwick.util.content.cleaner.TagAndAttributeFilter;
import uk.ac.warwick.util.core.HtmlUtils;

public class DefaultHtmlContentWriter
implements HtmlContentWriter {
    public static final String[] MCE_TAGS = new String[]{"href", "src", "style", "coords", "shape"};
    private final TagAndAttributeFilter filter;
    private final BodyContentFilter contentFilter;
    private final Schema schema = new HTML5Schema();

    public DefaultHtmlContentWriter(TagAndAttributeFilter tagAndAttributeFilter, BodyContentFilter cFilter) {
        this.filter = tagAndAttributeFilter;
        this.contentFilter = cFilter;
    }

    @Override
    public String renderStartTag(String tagName, Attributes atts, MutableContent mc) {
        StringBuilder tagSb = new StringBuilder();
        tagSb.append("<" + tagName);
        tagSb.append((CharSequence)this.constructAttributes(atts, tagName));
        if (this.isSelfCloser(tagName)) {
            tagSb.append(" /");
        }
        tagSb.append(">");
        return tagSb.toString();
    }

    @Override
    public String renderEndTag(String tagName) {
        return "</" + tagName + ">";
    }

    @Override
    public boolean isSelfCloser(String tagName) {
        ElementType type = this.schema.getElementType(tagName);
        if (type == null) {
            return false;
        }
        return type.model() == 0;
    }

    private StringBuilder constructAttributes(Attributes atts, String tagName) {
        StringBuilder result = new StringBuilder();
        boolean containsMce = this.containsMceAttributes(atts);
        HashSet<String> usedAttributes = new HashSet<String>();
        block0: for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (containsMce) {
                for (String tag : MCE_TAGS) {
                    if (name.equals(tag) && this.containsAttribute(atts, "mce_" + tag) || name.equals(tag) && this.containsAttribute(atts, "_mce_" + tag) || name.equals(tag) && this.containsAttribute(atts, "data-mce-" + tag)) continue block0;
                    if (!name.equals("mce_" + tag) && !name.equals("_mce_" + tag) && !name.equals("data-mce-" + tag)) continue;
                    name = tag;
                }
            }
            if (!this.filter.isAttributeAllowed(tagName, name, value)) continue;
            String attrName = this.contentFilter.handleAttributeName(name, tagName);
            String attrValue = this.contentFilter.handleAttributeValue(this.htmlEscapeAll(value), tagName, name);
            if (!usedAttributes.add(attrName)) continue;
            result.append(" " + attrName + "=\"" + attrValue + "\"");
        }
        if (tagName.equals("img") && !this.containsAttribute(atts, "border")) {
            result.append(" border=\"0\"");
        }
        return result;
    }

    private boolean containsMceAttributes(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getLocalName(i).startsWith("mce_") && !atts.getLocalName(i).startsWith("_mce_") && !atts.getLocalName(i).startsWith("data-mce-")) continue;
            return true;
        }
        return false;
    }

    private boolean containsAttribute(Attributes atts, String name) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getLocalName(i).equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String htmlEscapeAll(String html) {
        return HtmlUtils.htmlEscape((String)html);
    }

    @Override
    public void setDelegate(HtmlContentWriter contentWriter) {
        throw new UnsupportedOperationException();
    }
}

