/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public final class DocumentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentUtils.class);
    private static final List<String> HIDDEN_TAGS = Arrays.asList("script", "style", "input", "textarea", "select");
    private static DOMImplementation documentFactory;

    private DocumentUtils() {
    }

    public static List<Element> getElementsByTagName(Node parent, String tagName) {
        ArrayList results = Lists.newArrayList();
        DocumentUtils.getElementsByTagName(parent, tagName, results);
        return results;
    }

    private static void getElementsByTagName(Node parent, String tagName, List<Element> list) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeName().equalsIgnoreCase(tagName)) {
                list.add((Element)node);
                continue;
            }
            DocumentUtils.getElementsByTagName(node, tagName, list);
        }
    }

    public static Node getElementById(Node parent, String id) {
        NodeList children = parent.getChildNodes();
        Node result = null;
        for (int i = 0; i < children.getLength() && result == null; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            String thisId = DocumentUtils.getAttribute(node, "id");
            if (thisId != null && thisId.equals(id)) {
                return node;
            }
            result = DocumentUtils.getElementById(node, id);
        }
        return result;
    }

    public static Node getFirstOccurrenceOfElementByTagName(Node parent, String tagName) {
        NodeList children = parent.getChildNodes();
        Node result = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeName().equalsIgnoreCase(tagName)) {
                result = node;
                break;
            }
            Node thisResult = DocumentUtils.getFirstOccurrenceOfElementByTagName(node, tagName);
            if (thisResult == null) continue;
            result = thisResult;
            break;
        }
        return result;
    }

    public static Node getFirstNamedChildNode(Node root, String nodeName) {
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!current.getNodeName().equalsIgnoreCase(nodeName)) continue;
            return current;
        }
        return null;
    }

    public static Node getBody(Document document) {
        Node body = DocumentUtils.getFirstOccurrenceOfElementByTagName(document, "body");
        if (body == null) {
            body = document;
        }
        return body;
    }

    public static String getAttribute(Node node, String attributeName) {
        return node.getAttributes().getNamedItem(attributeName) == null ? null : node.getAttributes().getNamedItem(attributeName).getNodeValue();
    }

    public static String getContents(Node node) {
        if (node instanceof Text) {
            return node.getNodeValue() != null ? " " + node.getNodeValue() : "";
        }
        StringBuilder result = new StringBuilder();
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                if (HIDDEN_TAGS.contains(child.getNodeName().toLowerCase())) continue;
                result.append(DocumentUtils.getContents(child));
            }
        }
        return result.toString();
    }

    public static String getInnerHTML(Node node) {
        StringBuilder sb = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            sb.append(DocumentUtils.getHtml(children.item(i)));
        }
        return sb.toString();
    }

    private static String getHtml(Node node) {
        StringBuilder sb = new StringBuilder();
        if (node instanceof Element) {
            sb.append("<");
            sb.append(node.getNodeName());
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append(" " + attributes.item(i).getNodeName() + "=\"" + attributes.item(i).getNodeValue() + "\"");
            }
            sb.append(">");
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                sb.append(DocumentUtils.getHtml(children.item(i)));
            }
            sb.append("</" + node.getNodeName() + ">");
        } else if (node instanceof Text) {
            sb.append(node.getNodeValue());
        }
        return sb.toString();
    }

    public static Node getNextNonTextSibling(Node node) {
        if (node.getNextSibling() == null || !(node.getNextSibling() instanceof Text)) {
            return node.getNextSibling();
        }
        return DocumentUtils.getNextNonTextSibling(node.getNextSibling());
    }

    public static synchronized void setDOMImplementation(DOMImplementation implementation) {
        documentFactory = implementation;
    }

    public static synchronized DOMImplementation getDOMImplementation() {
        if (documentFactory != null) {
            return documentFactory;
        }
        DOMImplementation df = null;
        try {
            df = DocumentUtils.fromRegistry();
        }
        catch (Exception e1) {
            LOGGER.debug("Couldn't find DOMImplementation in DOMImplementationRegistry");
        }
        if (df == null) {
            try {
                df = DocumentUtils.fromXerces();
            }
            catch (Exception e2) {
                LOGGER.debug("No valid xerces implementation");
            }
        }
        if (df == null) {
            try {
                documentFactory = DocumentUtils.fromInternalXerces();
                return documentFactory;
            }
            catch (Exception e3) {
                throw new IllegalStateException("Couldn't find a DOMImplementation", e3);
            }
        }
        documentFactory = df;
        return df;
    }

    private static DOMImplementation fromRegistry() throws Exception {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        return registry.getDOMImplementation("XML 1.0 Traversal 2.0");
    }

    private static DOMImplementation fromXerces() throws Exception {
        return (DOMImplementation)Class.forName("org.apache.xerces.dom.DOMImplementationImpl").getMethod("getDOMImplementation", new Class[0]).invoke(null, new Object[0]);
    }

    private static DOMImplementation fromInternalXerces() throws Exception {
        return (DOMImplementation)Class.forName("com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl").getMethod("getDOMImplementation", new Class[0]).invoke(null, new Object[0]);
    }
}

