/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlTransformer;

public class MediaUrlTransformerTest {
    @Test
    public void tagMatchingPatternWorks() {
        Pattern p = new MediaUrlTransformer(null, null).getTagPattern();
        String input = "Test words [media]Contents[/media] More words";
        Matcher m = p.matcher(input);
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"Contents", (Object)m.group(3));
    }

    @Test
    public void tagMatchingPatternWorksOnMultipleTags() {
        Pattern p = new MediaUrlTransformer(null, null).getTagPattern();
        String input = "Test words [media]Contents[/media] More words [media]Contents 2[/media] More words";
        Matcher m = p.matcher(input);
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"Contents", (Object)m.group(3));
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"Contents 2", (Object)m.group(3));
    }

    @Test
    public void transforming() {
        HashMap<String, 1> handlers = new HashMap<String, 1>();
        handlers.put("uppercase", new MediaUrlHandler(){

            public boolean recognises(String url) {
                return true;
            }

            public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
                return url.toUpperCase();
            }
        });
        MediaUrlTransformer transformer = new MediaUrlTransformer(handlers, null);
        String input = "test words [media]golden trumpet[/media] test words";
        String expected = "test words GOLDEN TRUMPET test words";
        String output = transformer.apply(new MutableContent(null, input)).getContent();
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void parameters() {
        HashMap<String, 2> handlers = new HashMap<String, 2>();
        handlers.put("uppercase", new MediaUrlHandler(){

            public boolean recognises(String url) {
                return true;
            }

            public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
                String result = url.toUpperCase() + "(";
                result = result + "width:" + parameters.get("width") + ",";
                result = result + "height:" + parameters.get("height") + ",";
                result = result + "type:" + parameters.get("type");
                result = result + ")";
                return result;
            }
        });
        MediaUrlTransformer transformer = new MediaUrlTransformer(handlers, null);
        String input = "test words [media width=100 height=\"200\" type='uppercase']trumpet[/media] test words";
        String expected = "test words TRUMPET(width:100,height:200,type:uppercase) test words";
        String output = transformer.apply(new MutableContent(null, input)).getContent();
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void contentTypeOverride() {
        HashMap<String, MediaUrlHandler> handlers = new HashMap<String, MediaUrlHandler>();
        handlers.put("uppercase", new MediaUrlHandler(){

            public boolean recognises(String url) {
                return true;
            }

            public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
                return url.toUpperCase();
            }
        });
        handlers.put("lowercase", new MediaUrlHandler(){

            public boolean recognises(String url) {
                return false;
            }

            public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
                return url.toLowerCase();
            }
        });
        MediaUrlTransformer transformer = new MediaUrlTransformer(handlers, null);
        String input = "test words [media]golden trumpet[/media] test words [media type='lowercase']Super LowerCase[/media] test words";
        String expected = "test words GOLDEN TRUMPET test words super lowercase test words";
        String output = transformer.apply(new MutableContent(null, input)).getContent();
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void badContentType() {
        HashMap<String, 5> handlers = new HashMap<String, 5>();
        handlers.put("uppercase", new MediaUrlHandler(){

            public boolean recognises(String url) {
                return true;
            }

            public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
                return url.toUpperCase();
            }
        });
        MediaUrlTransformer transformer = new MediaUrlTransformer(handlers, null);
        String input = "test words [media type='somemadeuptype']golden trumpet[/media] test words";
        String output = transformer.apply(new MutableContent(null, input)).getContent();
        Assert.assertEquals((Object)input, (Object)output);
    }
}

