/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Random;
import org.hamcrest.Description;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.content.texttransformers.media.FlvMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MetadataHandler;

public final class FlvMediaUrlHandlerTest {
    private final Mockery m = new JUnit4Mockery();
    private final FlvMediaUrlHandler handler = new FlvMediaUrlHandler("http://www2.warwick.ac.uk/static_war/render/flvplayer.swf", "http://www2.warwick.ac.uk/static_war/render/flvplayer-4.2.swf");
    private final MetadataHandler metadataHandler = (MetadataHandler)this.m.mock(MetadataHandler.class);

    @Test
    public void recognises() {
        Assert.assertTrue((boolean)this.handler.recognises("file.flv"));
        Assert.assertTrue((boolean)this.handler.recognises("file.f4v"));
        Assert.assertTrue((boolean)this.handler.recognises("file.f4p"));
        Assert.assertTrue((boolean)this.handler.recognises("file.mp4"));
        Assert.assertTrue((boolean)this.handler.recognises("file.m4v"));
        Assert.assertTrue((boolean)this.handler.recognises("rtmp://something.something"));
        Assert.assertFalse((boolean)this.handler.recognises("anything"));
    }

    @Test
    public void itWorks() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        Assert.assertTrue((boolean)this.handler.getHtml("file.mp4", parameters, null).startsWith("<notextile>"));
        Assert.assertTrue((boolean)this.handler.getHtml("file.mp4", parameters, null).contains("requestedWidth = 425"));
        Assert.assertTrue((boolean)this.handler.getHtml("file.mp4", parameters, null).contains("requestedHeight = 350"));
    }

    @Test
    public void bigVideo() {
        this.handler.setMetadataHandler(this.metadataHandler);
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((MetadataHandler)this.one(FlvMediaUrlHandlerTest.this.metadataHandler)).handle("../big_buck_bunny.mp4", parameters, null);
                this.will(new Action(){

                    public void describeTo(Description description) {
                        description.appendText("populate metadata");
                    }

                    public Object invoke(Invocation invocation) throws Throwable {
                        parameters.put("width", "6,40");
                        parameters.put("height", "360");
                        parameters.put("previewimage", "http://augustus.warwick.ac.uk/services/its/elab/about/people/mmannion/big_buck_bunny.mp4?preview");
                        parameters.put("mime_type", "video/mp4");
                        return null;
                    }
                });
            }
        });
        String html = this.handler.getHtml("../big_buck_bunny.mp4", parameters, null);
        Assert.assertTrue((boolean)html.startsWith("<notextile>"));
        Assert.assertTrue((boolean)html.contains("requestedWidth = 640"));
        this.m.assertIsSatisfied();
    }

    @Test
    public void withPercentageWidthAndAutoHeight() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        parameters.put("width", "100%");
        parameters.put("height", "auto");
        String html = this.handler.getHtml("file.mp4", parameters, null);
        Assert.assertTrue((boolean)html.startsWith("<notextile>"));
        Assert.assertTrue((boolean)this.handler.getHtml("file.mp4", parameters, null).contains("requestedWidth = \"100%\""));
        Assert.assertTrue((boolean)html.contains("preload=\"none\""));
        parameters.put("preload", "metadata");
        html = this.handler.getHtml("file.mp4", parameters, null);
        Assert.assertTrue((boolean)html.contains("vidEl.setAttribute('preload', 'metadata');"));
    }

    @Test
    public void withNoHeight() {
        this.handler.setMetadataHandler(this.metadataHandler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        parameters.put("width", "500");
        parameters.put("closeButtonImgUrl", "//sawtooth.warwick.ac.uk/static_war/render/images/mediaplayers/closebox.png");
        parameters.put("absoluteUrl", "[absolute-url]urss_1-5.mp4[/absolute-url]");
        String url = "urss_1-5.mp4";
        String html = this.handler.getHtmlInner(url, parameters);
        Assert.assertTrue((boolean)html.startsWith("<notextile>"));
        Assert.assertTrue((boolean)html.contains("requestedWidth = 500"));
        this.m.assertIsSatisfied();
    }

    @Test
    public void withTitle() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        parameters.put("title", "Click here for a good time");
        String html = this.handler.getHtml("file.mp4", parameters, null);
        Assert.assertTrue((boolean)html.startsWith("<notextile>"));
        Assert.assertTrue((boolean)html.contains("<a href=\"file.mp4?forceOpenSave=true\""));
        Assert.assertTrue((boolean)html.contains("Click here for a good time</a>"));
        Assert.assertTrue((boolean)html.contains("<head>"));
    }

    @Test
    public void withAlternateRenditions() throws Exception {
        this.handler.setMetadataHandler(this.metadataHandler);
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((MetadataHandler)this.one(FlvMediaUrlHandlerTest.this.metadataHandler)).handle("file.mp4", parameters, null);
                this.will(new Action(){

                    public void describeTo(Description description) {
                        description.appendText("populate metadata");
                    }

                    public Object invoke(Invocation invocation) throws Throwable {
                        parameters.put("width", "6,40");
                        parameters.put("height", "360");
                        parameters.put("previewimage", "file.jpg");
                        parameters.put("mime_type", "video/mp4");
                        LinkedHashMap alternateRenditions = Maps.newLinkedHashMap();
                        alternateRenditions.put("video/webm", "file.webm");
                        alternateRenditions.put("video/ogg", "file.ogg");
                        parameters.put("alternateRenditions", alternateRenditions);
                        return null;
                    }
                });
            }
        });
        String html = this.handler.getHtml("file.mp4", parameters, null);
        Assert.assertFalse((boolean)html.contains("vidEl.insert({top:new Element('source', {"));
        Assert.assertTrue((boolean)html.startsWith("<notextile>"));
        Assert.assertTrue((boolean)html.contains("requestedWidth = 640"));
        Assert.assertTrue((boolean)html.contains("requestedHeight = 360"));
        this.m.assertIsSatisfied();
    }

    @Test
    public void withAlternateRenditionsMP4NotFirst() throws Exception {
        this.handler.setMetadataHandler(this.metadataHandler);
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("random", new Random());
        parameters.put("align", "left");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((MetadataHandler)this.one(FlvMediaUrlHandlerTest.this.metadataHandler)).handle("file.webm", parameters, null);
                this.will(new Action(){

                    public void describeTo(Description description) {
                        description.appendText("populate metadata");
                    }

                    public Object invoke(Invocation invocation) throws Throwable {
                        parameters.put("width", "6,40");
                        parameters.put("height", "360");
                        parameters.put("previewimage", "file.jpg");
                        parameters.put("mime_type", "video/webm");
                        LinkedHashMap alternateRenditions = Maps.newLinkedHashMap();
                        alternateRenditions.put("video/mp4", "file.mp4");
                        alternateRenditions.put("video/ogg", "file.ogg");
                        parameters.put("alternateRenditions", alternateRenditions);
                        return null;
                    }
                });
            }
        });
        String html = this.handler.getHtml("file.webm", parameters, null);
        System.out.println(html);
        Assert.assertTrue((boolean)html.startsWith("<notextile>"));
        Assert.assertTrue((html.indexOf("source src=\"file.mp4\"") < html.indexOf("source src=\"file.ogg\"") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)html.contains("requestedWidth = 640"));
        Assert.assertTrue((boolean)html.contains("requestedHeight = 360"));
        this.m.assertIsSatisfied();
    }
}

