/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import junit.framework.TestCase;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.DoNothingTextTransformer;
import uk.ac.warwick.util.content.texttransformers.SquareBracketEscapingTransformer;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public class SquareBracketEscapingTransformerTest
extends TestCase {
    private static final String OPEN = "&#91;";
    private static final String CLOSE = "&#93;";

    public void testMediaTagsAreEscaped() {
        String input = "Test [media crab=blah]url[/media] frank";
        String expected = "Test &#91;media crab=blah&#93;url&#91;/media&#93; frank";
        this.verify(input, expected);
    }

    public void testFootnotesAreNotEscaped() {
        String input = "Test some text with a footnote[1] which should be left alone";
        this.verify(input, input);
    }

    public void testNamedLinksAreNotEscaped() {
        String input = "Test this \"Link\":testlink \n\n [testlink]http://url.com/ ";
        this.verify(input, input);
    }

    private void verify(String input, String expected) {
        SquareBracketEscapingTransformer trans = new SquareBracketEscapingTransformer((TextTransformer)new DoNothingTextTransformer());
        String text = input;
        text = trans.preTransform(new MutableContent(null, text)).getContent();
        SquareBracketEscapingTransformerTest.assertEquals((String)expected, (String)text);
        text = trans.postTransform(new MutableContent(null, text)).getContent();
        SquareBracketEscapingTransformerTest.assertEquals((String)input, (String)text);
    }
}

