package uk.ac.warwick.util.content.texttransformers;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.*;

import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.AbstractHtmlCleanerTest;

public final class BodyCleanupHtmlTransformerTest extends AbstractHtmlCleanerTest {
    
    private BodyCleanupHtmlTransformer transformer;
    
    @Before
    public void setUp() {
        transformer = new BodyCleanupHtmlTransformer(cleaner);
    }
    
    @Test
    public void transformJustBody() {
        String input = "<html><head>this is left alone <li></head>" +
                "<body>" +
                "<p>Test transform</p>" +
                "<p>Remove <u>underlining</u>" +
                "</body>" +
                "</html>";
        
        String result = transformer.apply(new MutableContent(null, input)).getContent();
        
        assertThat(result, containsString("<html><head>this is left alone <li></head>"));
        assertThat(result, not(containsString("<u>")));
        assertThat(result, containsString("<p>Test transform</p>"));
        assertThat(result, containsString("<p>Remove underlining</p>"));
        assertThat(result, containsString("</body>"));
    }
    
    @Test
    public void transformAll() {
        String input = 
                "<p>Test transform <ul><li></ul></p>" +
                "<p>Remove <u>underlining</u>";
        
        String result = transformer.apply(new MutableContent(null, input)).getContent();
        
        assertThat(result, not(containsString("<u>")));
        assertThat(result, not(containsString("<html>")));
        assertThat(result, not(containsString("</body>")));
        
        assertThat(result, containsString("</li>"));
        assertThat(result, containsString("<p>Test transform"));        
    }
}
