/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.BasicCache;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;

final class UpdateCacheEntryTask<K extends Serializable, V extends Serializable, T>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCacheEntryTask.class);
    private final Collection<BasicCache.KeyEntry<K, V, T>> entries;
    private final BasicCache<K, V, T> owner;

    public UpdateCacheEntryTask(BasicCache<K, V, T> cache, BasicCache.KeyEntry<K, V, T> entry) {
        this(cache, Collections.singletonList(entry));
    }

    public UpdateCacheEntryTask(BasicCache<K, V, T> cache, Collection<BasicCache.KeyEntry<K, V, T>> entries) {
        this.owner = cache;
        this.entries = entries;
    }

    public static <K extends Serializable, V extends Serializable, T> UpdateCacheEntryTask<K, V, T> task(BasicCache<K, V, T> cache, BasicCache.KeyEntry<K, V, T> entry) {
        return new UpdateCacheEntryTask<K, V, T>(cache, entry);
    }

    public static <K extends Serializable, V extends Serializable, T> UpdateCacheEntryTask<K, V, T> task(BasicCache<K, V, T> cache, Collection<BasicCache.KeyEntry<K, V, T>> entry) {
        return new UpdateCacheEntryTask<K, V, T>(cache, entry);
    }

    @Override
    public void run() {
        try {
            if (this.entries.size() == 1) {
                this.owner.updateEntry(this.entries.iterator().next());
            } else {
                this.owner.updateEntries(this.entries);
            }
        }
        catch (CacheEntryUpdateException e) {
            LOGGER.error("Failed to update entry asynchronously", (Throwable)e);
        }
    }
}

