/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CustomCacheExpiry;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.core.DateTimeUtils;

public abstract class TTLCacheExpiryStrategy<K extends Serializable, V extends Serializable>
implements CacheExpiryStrategy<K, V> {
    public static <K extends Serializable, V extends Serializable> TTLCacheExpiryStrategy<K, V> eternal() {
        return TTLCacheExpiryStrategy.forTTL(CacheEntryFactory.TIME_TO_LIVE_ETERNITY);
    }

    public static <K extends Serializable, V extends Serializable> TTLCacheExpiryStrategy<K, V> forTTL(final Duration ttl) {
        return new TTLCacheExpiryStrategy<K, V>(){

            @Override
            public Pair<Number, TimeUnit> getTTL(CacheEntry<K, V> entry) {
                if (entry.getValue() != null && entry.getValue().getClass().isAnnotationPresent(CustomCacheExpiry.class)) {
                    return Pair.of((Object)entry.getValue().getClass().getAnnotation(CustomCacheExpiry.class).value(), (Object)((Object)TimeUnit.MILLISECONDS));
                }
                return Pair.of((Object)(ttl.getSeconds() * 1000L + (long)(ttl.getNano() / 1000000)), (Object)((Object)TimeUnit.MILLISECONDS));
            }
        };
    }

    @Override
    public final boolean isExpired(CacheEntry<K, V> entry) {
        long now;
        Duration ttl = this.getTTLDuration(entry);
        if (ttl.equals(CacheEntryFactory.TIME_TO_LIVE_ETERNITY)) {
            return false;
        }
        long expires = entry.getTimestamp() + ttl.toMillis();
        return expires <= (now = Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).toEpochMilli());
    }

    @Override
    public boolean isStale(CacheEntry<K, V> entry) {
        return this.isExpired(entry);
    }

    @Override
    public abstract Pair<Number, TimeUnit> getTTL(CacheEntry<K, V> var1);
}

