/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.HashMapCacheStore;

public class HashMapCacheStoreTest {
    @Test
    public void multipleStores() {
        HashMapCacheStore cache = new HashMapCacheStore.Builder("MyCache", null).buildStore();
        HashMapCacheStore cache2 = new HashMapCacheStore.Builder("MyCache", null).buildStore();
        HashMapCacheStore cache3 = new HashMapCacheStore.Builder("MyCache", null).buildStore();
        cache.put(new CacheEntry((Serializable)((Object)"one"), (Serializable)((Object)"gamma")), Duration.ofSeconds(10L));
        Assert.assertEquals((Object)"gamma", (Object)cache2.get((Serializable)((Object)"one")).getValue());
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("blah", "blah"));
        cache3.put(new CacheEntry((Serializable)((Object)"two"), list), Duration.ofSeconds(10L));
        Assert.assertEquals(list, (Object)cache3.get((Serializable)((Object)"two")).getValue());
        try {
            ArrayList l = (ArrayList)cache3.get((Serializable)((Object)"one")).getValue();
            Assert.fail((String)"should have failed with incompatible value");
        }
        catch (ClassCastException l) {
            // empty catch block
        }
        try {
            String s = (String)((Object)cache2.get((Serializable)((Object)"two")).getValue());
            Assert.fail((String)"should have failed with incompatible value");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void getInstance() {
        for (int i = 0; i < 1000; ++i) {
            Assert.assertNotNull((Object)new HashMapCacheStore.Builder("store" + i % 5, null).buildStore());
        }
    }
}

