package uk.ac.warwick.util.cache.memcached;

import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class MemcachedCacheStoreTest extends AbstractMemcachedCacheStoreTest<String, String> {

    @Test
    public void creation() throws Exception {
        CacheEntry<String, String> string = cacheStore.get("token:abcdefghij");
        assertNull(string);

        CacheEntry<String, String> entry = new CacheEntry<String, String>("token:12345", "Johnny");
        cacheStore.put(entry, Duration.ofSeconds(10));

        assertEquals(entry.getValue(), cacheStore.get("token:12345").getValue());
        assertEquals(entry.getValue(), cacheStore.get("token:12345").getValue());

        Map<String, CacheEntry<String, String>> bulk = cacheStore.getAll(Arrays.asList("token:12345", "token:67890"));
        assertEquals(2, bulk.size());
        assertEquals(entry.getValue(), bulk.get("token:12345").getValue());
        assertNull(bulk.get("token:67890"));

        // Check the cacheStore stats are right
        assertSize(1);

        Map<String, String> stats = client.getStats().values().iterator().next();
        assertEquals("3", stats.get("get_hits"));
        assertEquals(Integer.toString(2 + 1), stats.get("get_misses")); // One extra cache miss for the initial namespace lookup

        // Clear with no namespace
        cacheStore.clear();
        assertNull(cacheStore.get("token:12345"));

        cacheStore.put(entry, Duration.ofSeconds(10));
        assertEquals(entry.getValue(), cacheStore.get("token:12345").getValue());

        // Clear with a namespace
        cacheStore.clear();
        assertNull(cacheStore.get("token:12345"));
    }
}
