/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithmRegistry;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.BasicCache;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryFactoryWithDataInitialisation;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CacheStatistics;
import uk.ac.warwick.util.cache.CacheStore;
import uk.ac.warwick.util.cache.CacheStoreUnavailableException;
import uk.ac.warwick.util.cache.CacheWithDataInitialisation;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.TTLCacheExpiryStrategy;
import uk.ac.warwick.util.core.DateTimeUtils;

public final class MemcachedCacheStore<K extends Serializable, V extends Serializable>
implements CacheStore<K, V> {
    public static final String CUSTOM_CONFIG_URL = "/memcached.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(MemcachedCacheStore.class);
    private static final int SIZE_INFO_THRESHOLD = 102400;
    private static final int SIZE_WARN_THRESHOLD = 0x200000;
    private static final long MEMCACHED_TTL_SECONDS_THRESHOLD = TimeUnit.DAYS.toSeconds(30L);
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static MemcachedClient defaultMemcachedClient;
    private static final String NAMESPACE_KEY_PREFIX = "-namespace";
    private static final Duration namespaceValueExpiryDuration;
    private static final int DEFAULT_BULK_BATCH_SIZE = 5000;
    private final String cacheName;
    private final long timeoutInSeconds;
    private final MemcachedClient memcachedClient;
    private final String namespaceKey;
    private Integer namespaceValue;
    private OffsetDateTime namespaceValueExpiry = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION);
    private final int bulkBatchSize;

    MemcachedCacheStore(String name, Duration timeout, MemcachedClient client) {
        this.cacheName = name;
        this.namespaceKey = name + NAMESPACE_KEY_PREFIX;
        this.timeoutInSeconds = timeout.getSeconds();
        this.memcachedClient = client;
        this.bulkBatchSize = 5000;
    }

    private static Properties customProperties() {
        String location = System.getProperty("warwick.memcached.config");
        InputStream customPropertiesStream = location == null || location.equals("") ? MemcachedCacheStore.class.getResourceAsStream(CUSTOM_CONFIG_URL) : MemcachedCacheStore.class.getResourceAsStream(location);
        if (customPropertiesStream != null) {
            Properties customProperties = new Properties();
            try {
                customProperties.load(customPropertiesStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load configuration from " + (location == null || location.equals("") ? CUSTOM_CONFIG_URL : location));
            }
            return customProperties;
        }
        return new Properties();
    }

    MemcachedCacheStore(String name, Duration timeout) {
        this(name, timeout, MemcachedCacheStore.customProperties());
    }

    MemcachedCacheStore(String name, Duration timeout, Properties customProperties) {
        this.cacheName = name;
        this.namespaceKey = name + NAMESPACE_KEY_PREFIX;
        this.timeoutInSeconds = timeout.getSeconds();
        int n = this.bulkBatchSize = customProperties.containsKey("memcached.bulkBatchSize") ? Integer.parseInt(customProperties.getProperty("memcached.bulkBatchSize")) : 5000;
        if (defaultMemcachedClient == null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getResourceAsStream("/memcached-default.properties"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't load default properties for memcached", e);
            }
            Enumeration<?> en = customProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = customProperties.getProperty(key);
                properties.setProperty(key, value);
            }
            SerializingTranscoder transcoder = new SerializingTranscoder();
            transcoder.setCompressionThreshold(Integer.parseInt(properties.getProperty("memcached.transcoder.compressionThreshold")));
            ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder().setDaemon(Boolean.parseBoolean(properties.getProperty("memcached.daemon"))).setFailureMode(FailureMode.valueOf((String)properties.getProperty("memcached.failureMode"))).setHashAlg(HashAlgorithmRegistry.lookupHashAlgorithm((String)properties.getProperty("memcached.hashAlgorithm"))).setLocatorType(ConnectionFactoryBuilder.Locator.valueOf((String)properties.getProperty("memcached.locatorType"))).setMaxReconnectDelay(Long.parseLong(properties.getProperty("memcached.maxReconnectDelay"))).setOpQueueFactory((OperationQueueFactory)new ConfigurableOperationQueueFactory(Integer.parseInt(properties.getProperty("memcached.maxOperationsQueueSize")))).setReadOpQueueFactory((OperationQueueFactory)new ConfigurableOperationQueueFactory(Integer.parseInt(properties.getProperty("memcached.maxOperationsQueueSize")))).setWriteOpQueueFactory((OperationQueueFactory)new ConfigurableOperationQueueFactory(Integer.parseInt(properties.getProperty("memcached.maxOperationsQueueSize")))).setOpQueueMaxBlockTime(Long.parseLong(properties.getProperty("memcached.opQueueMaxBlockTime"))).setOpTimeout(Long.parseLong(properties.getProperty("memcached.opTimeout"))).setProtocol(ConnectionFactoryBuilder.Protocol.valueOf((String)properties.getProperty("memcached.protocol"))).setReadBufferSize(Integer.parseInt(properties.getProperty("memcached.readBufferSize"))).setShouldOptimize(Boolean.parseBoolean(properties.getProperty("memcached.shouldOptimize"))).setTimeoutExceptionThreshold(Integer.parseInt(properties.getProperty("memcached.timeoutExceptionThreshold"))).setUseNagleAlgorithm(Boolean.parseBoolean(properties.getProperty("memcached.useNagleAlgorithm"))).setTranscoder((Transcoder)transcoder);
            try {
                Class<?> clientModeClass = Class.forName("net.spy.memcached.ClientMode");
                ConnectionFactoryBuilder.class.getMethod("setClientMode", clientModeClass).invoke((Object)builder, Enum.valueOf(clientModeClass, "Static"));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.debug("Amazon ElastiCache client not detected, using base spymemcached", (Throwable)e);
            }
            ConnectionFactory connectionFactory = builder.build();
            String servers = properties.getProperty("memcached.servers");
            try {
                defaultMemcachedClient = new MemcachedClient(connectionFactory, AddrUtil.getAddresses((String)servers));
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't connect to memcached", e);
            }
        }
        this.memcachedClient = defaultMemcachedClient;
    }

    private Integer getNamespaceValue() {
        if (this.namespaceValueExpiry.isBefore(OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION))) {
            Object namespaceValueObj = this.memcachedClient.get(this.namespaceKey);
            this.namespaceValueExpiry = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).plus(namespaceValueExpiryDuration);
            if (namespaceValueObj instanceof String) {
                this.namespaceValue = namespaceValueObj.equals("") ? null : Integer.valueOf((String)namespaceValueObj);
            }
        }
        return this.namespaceValue;
    }

    private String getFullyQualifiedKey(K key) throws OperationTimeoutException {
        String separator = ":";
        String namespace = "";
        Integer namespaceValue = this.getNamespaceValue();
        if (namespaceValue != null) {
            namespace = namespaceValue.toString() + separator;
        }
        byte[] encodedKey = this.memcachedClient.getTranscoder().encode(key).getData();
        String keyAsString = MemcachedCacheStore.md5DigestAsHex(encodedKey);
        return this.getName() + separator + namespace + keyAsString;
    }

    @Override
    public CacheEntry<K, V> get(K key) {
        try {
            Object value = this.memcachedClient.get(this.getFullyQualifiedKey(key));
            if (value == null || value instanceof String) {
                return null;
            }
            return (CacheEntry)value;
        }
        catch (CancellationException | OperationTimeoutException throwable) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAll(List<K> keys) {
        Map results = keys.stream().collect(HashMap::new, (m, k) -> {
            CacheEntry cfr_ignored_0 = m.put(k, null);
        }, HashMap::putAll);
        try {
            Map prefixedKeys = keys.stream().collect(Collectors.toMap(Function.identity(), this::getFullyQualifiedKey));
            HashMap cachedEntries = new HashMap();
            ArrayList<String> prefixedKeysValues = new ArrayList<String>(prefixedKeys.values());
            if (prefixedKeys.size() <= this.bulkBatchSize) {
                cachedEntries.putAll(this.memcachedClient.getBulk(prefixedKeysValues));
            } else {
                for (int start = 0; start < prefixedKeys.size(); start += this.bulkBatchSize) {
                    int end = Math.min(start + this.bulkBatchSize, prefixedKeys.size());
                    List sublist = prefixedKeysValues.subList(start, end);
                    cachedEntries.putAll(this.memcachedClient.getBulk(sublist));
                }
            }
            prefixedKeys.forEach((key, prefixed) -> {
                Object value;
                if (cachedEntries.containsKey(prefixed) && (value = cachedEntries.get(prefixed)) != null && !(value instanceof String)) {
                    results.put(key, (CacheEntry)value);
                }
            });
        }
        catch (CancellationException | OperationTimeoutException throwable) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return results;
    }

    @Override
    public void put(final CacheEntry<K, V> entry, Duration ttl) throws CacheStoreUnavailableException {
        long ttlInSeconds;
        int ttlSeconds = ttl.getSeconds() > 0L ? ((ttlInSeconds = ttl.getSeconds()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (ttlInSeconds > MEMCACHED_TTL_SECONDS_THRESHOLD ? (int)(Instant.now().getEpochSecond() + ttlInSeconds) : (int)ttlInSeconds)) : (ttl.equals(CacheEntryFactory.TIME_TO_LIVE_ETERNITY) ? Integer.MAX_VALUE : (this.timeoutInSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.timeoutInSeconds));
        Transcoder oneTimeTranscoder = new Transcoder<CacheEntry<K, V>>(){
            private CachedData data;

            public CachedData encode(CacheEntry<K, V> o) {
                if (o != entry) {
                    throw new IllegalStateException();
                }
                if (this.data != null) {
                    return this.data;
                }
                this.data = MemcachedCacheStore.this.memcachedClient.getTranscoder().encode(o);
                return this.data;
            }

            public int getMaxSize() {
                return MemcachedCacheStore.this.memcachedClient.getTranscoder().getMaxSize();
            }

            public CacheEntry<K, V> decode(CachedData d) {
                throw new UnsupportedOperationException();
            }

            public boolean asyncDecode(CachedData d) {
                throw new UnsupportedOperationException();
            }
        };
        int size = oneTimeTranscoder.encode(entry).getData().length;
        if (size > 0x200000) {
            LOGGER.warn("Very large cache item stored in memcached (" + size + " bytes)", new Throwable());
        } else if (size > 102400) {
            LOGGER.info("Large cache item stored in memcached (" + size + " bytes)", new Throwable());
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache item stored in memcached (" + size + " bytes)", new Throwable());
        }
        try {
            this.memcachedClient.set(this.getFullyQualifiedKey(entry.getKey()), ttlSeconds, entry, oneTimeTranscoder);
        }
        catch (OperationTimeoutException e) {
            throw new CacheStoreUnavailableException(e);
        }
    }

    @Override
    public boolean remove(K key) {
        try {
            return (Boolean)this.memcachedClient.delete(this.getFullyQualifiedKey(key)).get();
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            return false;
        }
    }

    @Override
    public CacheStatistics getStatistics() throws CacheStoreUnavailableException {
        Map allStats = this.memcachedClient.getStats();
        long totalSize = 0L;
        int unavailableStores = 0;
        for (Map stats : allStats.values()) {
            try {
                if (stats.containsKey("curr_items")) {
                    totalSize += Long.parseLong((String)stats.get("curr_items"));
                    continue;
                }
                totalSize += Long.parseLong((String)stats.get("cur_items"));
            }
            catch (NumberFormatException e) {
                ++unavailableStores;
            }
        }
        if (unavailableStores == allStats.size()) {
            throw new CacheStoreUnavailableException("No memcached backends available");
        }
        this.namespaceValueExpiry = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).plus(namespaceValueExpiryDuration);
        return new CacheStatistics(totalSize);
    }

    @Override
    public void setMaxSize(int max) {
        LOGGER.debug("setMaxSize() called on MemcachedCacheStore which does not support it");
    }

    @Override
    public boolean clear() {
        this.namespaceValue = this.getNamespaceValue() == null ? Integer.valueOf(0) : Integer.valueOf(this.namespaceValue + 1);
        this.namespaceValueExpiry = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).plus(namespaceValueExpiryDuration);
        this.memcachedClient.set(this.namespaceKey, Integer.MAX_VALUE, (Object)this.namespaceValue);
        return true;
    }

    @Override
    public boolean contains(K key) {
        return this.get(key) != null;
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public void shutdown() {
        LOGGER.info("Shutting down MemcachedClient");
        if (this.memcachedClient != defaultMemcachedClient) {
            this.memcachedClient.shutdown();
        }
    }

    public static MemcachedClient getDefaultMemcachedClient() {
        return defaultMemcachedClient;
    }

    public static void shutdownDefaultMemcachedClient() {
        if (defaultMemcachedClient != null) {
            defaultMemcachedClient.shutdown();
            defaultMemcachedClient = null;
        }
    }

    private static String md5DigestAsHex(byte[] bytes) {
        return MemcachedCacheStore.digestAsHexString(MD5_ALGORITHM_NAME, bytes);
    }

    private static String digestAsHexString(String algorithm, byte[] bytes) {
        char[] hexDigest = MemcachedCacheStore.digestAsHexChars(algorithm, bytes);
        return new String(hexDigest);
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + algorithm + "\"", ex);
        }
    }

    private static byte[] digest(String algorithm, byte[] bytes) {
        return MemcachedCacheStore.getDigest(algorithm).digest(bytes);
    }

    private static char[] digestAsHexChars(String algorithm, byte[] bytes) {
        byte[] digest = MemcachedCacheStore.digest(algorithm, bytes);
        return MemcachedCacheStore.encodeHex(digest);
    }

    private static char[] encodeHex(byte[] bytes) {
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; i += 2) {
            byte b = bytes[i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
        }
        return chars;
    }

    static {
        namespaceValueExpiryDuration = Duration.ofSeconds(5L);
    }

    static class ConfigurableOperationQueueFactory
    implements OperationQueueFactory {
        private int capacity;

        ConfigurableOperationQueueFactory(int cap) {
            this.capacity = cap;
        }

        public BlockingQueue<Operation> create() {
            if (this.capacity > 0) {
                return new ArrayBlockingQueue<Operation>(this.capacity);
            }
            return new LinkedBlockingQueue<Operation>();
        }
    }

    public static class Builder<K extends Serializable, V extends Serializable, T>
    implements Caches.Builder<K, V, T> {
        private final String name;
        private CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory;
        private Duration expireAfterWrite = Duration.ofDays(30L);
        private CacheExpiryStrategy<K, V> expiryStrategy;
        private Properties properties;
        private boolean asynchronousUpdateEnabled;
        private boolean asynchronousOnly;

        public Builder(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory) {
            this.name = name;
            this.entryFactory = entryFactory;
        }

        private Builder(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory, Duration expireAfterWrite, CacheExpiryStrategy<K, V> expiryStrategy, Properties properties, boolean asynchronousUpdateEnabled, boolean asynchronousOnly) {
            this(name, entryFactory);
            this.expireAfterWrite = expireAfterWrite;
            this.expiryStrategy = expiryStrategy;
            this.properties = properties;
            this.asynchronousUpdateEnabled = asynchronousUpdateEnabled;
            this.asynchronousOnly = asynchronousOnly;
        }

        @Override
        public <U> Builder<K, V, U> dataInitialisingEntryFactory(CacheEntryFactoryWithDataInitialisation<K, V, U> entryFactory) {
            return new Builder<K, V, U>(this.name, entryFactory, this.expireAfterWrite, this.expiryStrategy, this.properties, this.asynchronousUpdateEnabled, this.asynchronousOnly);
        }

        @Override
        public Builder<K, V, T> expireAfterWrite(Duration duration) {
            this.expireAfterWrite = duration;
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> expiryStategy(CacheExpiryStrategy<K, V> expiryStrategy) {
            this.expiryStrategy = expiryStrategy;
            return this;
        }

        @Override
        public Builder<K, V, T> maximumSize(long size) {
            LOGGER.debug("Memcached doesn't support size-bound caches - ignoring");
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> asynchronous() {
            this.asynchronousUpdateEnabled = true;
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> asynchronousOnly() {
            this.asynchronousUpdateEnabled = true;
            this.asynchronousOnly = true;
            return this;
        }

        @Override
        public Builder<K, V, T> properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public MemcachedCacheStore<K, V> buildStore() {
            if (this.properties == null) {
                this.properties = MemcachedCacheStore.customProperties();
            }
            return new MemcachedCacheStore(this.name, this.expireAfterWrite, this.properties);
        }

        @Override
        public CacheWithDataInitialisation<K, V, T> build() {
            if (this.expiryStrategy == null) {
                this.expiryStrategy = TTLCacheExpiryStrategy.forTTL(this.expireAfterWrite);
            }
            return new BasicCache<K, V, T>(this.buildStore(), this.entryFactory, this.expiryStrategy, this.asynchronousUpdateEnabled, this.asynchronousOnly);
        }
    }
}

