/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import uk.ac.warwick.util.core.DateTimeUtils;

public class CacheEntry<K extends Serializable, V extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -4384852442875029950L;
    private final K key;
    private final V value;
    private final long created = Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).toEpochMilli();
    private volatile transient boolean updating;

    public CacheEntry(K k, V val) {
        this.key = k instanceof String ? new String((String)k) : k;
        this.value = val;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.created;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(CacheEntry.class)) {
            return false;
        }
        try {
            CacheEntry e = (CacheEntry)obj;
            return this.key.equals(e.key) && Objects.equals(e.value, this.value);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

