package uk.ac.warwick.util.cache.memcached;

import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheStoreUnavailableException;
import uk.ac.warwick.util.core.DateTimeUtils;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

import static org.junit.Assert.assertEquals;

public class MemcachedCacheStoreNamespaceExpiryTest extends AbstractMemcachedCacheStoreTest<String, String> {

    @Test
    public void namespaceValueExpiry() {
        OffsetDateTime thePast = OffsetDateTime.of(2040,1,1, 12, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime now = OffsetDateTime.of(2040,1,1, 12, 0, 3, 0, ZoneOffset.UTC);
        OffsetDateTime theFuture = OffsetDateTime.of(2040,1,1, 12, 0, 6, 0, ZoneOffset.UTC);

        // Put a value in the store. Will cause the namespace value to be set and cached for 5 seconds
        DateTimeUtils.useMockDateTime(thePast, () -> {
            CacheEntry<String, String> entry = new CacheEntry<>("token:12345", "Johnny");
            try {
                cacheStore.put(entry, Duration.ofSeconds(10));
            } catch (CacheStoreUnavailableException e) {
                e.printStackTrace();
            }
        });

        // Get the value in the store. Inside 5 seconds so no namespace value lookup
        DateTimeUtils.useMockDateTime(now, () -> cacheStore.get("token:12345"));

        // Get the value again. Outside 5 seconds so extra namespace value lookup
        DateTimeUtils.useMockDateTime(theFuture, () -> cacheStore.get("token:12345"));

        Map<String, String> stats = client.getStats().values().iterator().next();
        assertEquals("2", stats.get("get_hits"));
        assertEquals("2", stats.get("get_misses")); // Namespace value miss for the put and the _second_ get, but not the first (when cached in memory)
    }

}
