/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ant;

import java.io.FileReader;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildFileTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.core.io.FileSystemResource;

public class BatchHashTaskWithSaltTest
extends BuildFileTestBase {
    public void setUp() throws Exception {
        System.setProperty("root", "");
        String root = ((Object)((Object)this)).getClass().getResource("/batchchecksum-withsalt-build.xml").getPath();
        this.configureProject(root);
    }

    @Override
    public void tearDown() throws Exception {
        this.executeTarget("cleanup");
    }

    public void testMissingDir() {
        try {
            this.executeTarget("missing-fileset");
            BatchHashTaskWithSaltTest.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testMissingTarget() {
        try {
            this.executeTarget("missing-propertyfile");
            BatchHashTaskWithSaltTest.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testRun() throws Exception {
        BatchHashTaskWithSaltTest.assertFalse((boolean)new FileSystemResource("build/statichashes.properties").exists());
        this.executeTarget("run");
        Properties props = new Properties();
        props.load(new FileReader(this.tempDirectory.resolve("statichashes.properties").toFile()));
        Assert.assertThat((Object)props.getProperty("scripts/prototype-1.6.0.3.js"), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"168556932232"), (Matcher)Matchers.is((Object)"359133207138")));
        Assert.assertThat((Object)props.getProperty("somecsv.csv"), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"131825934230"), (Matcher)Matchers.is((Object)"119441393854")));
    }
}

