/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ant;

import com.yahoo.platform.yui.compressor.JarClassLoader;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.tools.ant.filters.TokenFilter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YUICompressorFilter
implements TokenFilter.Filter {
    private boolean disableOptimizations = false;
    private boolean verbose = false;
    private boolean munge = true;
    private boolean preserveAllSemiColons = false;
    private int linebreak = 0;

    public String filter(String text) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JarClassLoader loader = new JarClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)loader);
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(text), (ErrorReporter)new ErrorPrinter());
            StringWriter out = new StringWriter();
            compressor.compress((Writer)out, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
            String string = out.toString();
            return string;
        }
        catch (EvaluatorException e) {
            throw new RuntimeException("Error evaluating scripts", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading scripts", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public boolean isDisableOptimizations() {
        return this.disableOptimizations;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isMunge() {
        return this.munge;
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public boolean isPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public int getLinebreak() {
        return this.linebreak;
    }

    public void setLinebreak(int linebreak) {
        this.linebreak = linebreak;
    }

    private static class ErrorPrinter
    implements ErrorReporter {
        private ErrorPrinter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                System.err.println("\n[WARN] " + message);
            } else {
                System.err.println("\n[WARN] " + line + ':' + lineOffset + ": " + lineSource.replace("\t", "    "));
                String secondLine = "\n[WARN] ";
                int i = 0;
                while ((double)i <= (double)lineOffset + (Math.floor(Math.log10(line)) + 1.0) + (Math.floor(Math.log10(lineOffset)) + 1.0) + 1.0) {
                    secondLine = secondLine + " ";
                    ++i;
                }
                secondLine = secondLine + "^ " + message;
                System.err.println(secondLine);
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                System.err.println("\n[ERROR] " + message);
            } else {
                System.err.println("\n[ERROR] " + line + ':' + lineOffset + ": " + lineSource.replace("\t", "    "));
                String secondLine = "\n[ERROR] ";
                int i = 0;
                while ((double)i <= (double)lineOffset + (Math.floor(Math.log10(line)) + 1.0) + (Math.floor(Math.log10(lineOffset)) + 1.0) + 1.0) {
                    secondLine = secondLine + " ";
                    ++i;
                }
                secondLine = secondLine + "^ " + message;
                System.err.println(secondLine);
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

