/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import uk.ac.warwick.util.core.StringUtils;

public class BatchHashTask
extends Task {
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private File propertyfile;
    private int maxHashLength = -1;
    private String salt = "";

    public void addFileSet(FileSet s) {
        this.fileSets.add(s);
    }

    public void setPropertyfile(File f) {
        this.propertyfile = f;
    }

    public void setMaxhashlength(int max) {
        this.maxHashLength = max;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void execute() throws BuildException {
        if (this.fileSets.isEmpty()) {
            throw new BuildException("At least one fileset must be specified");
        }
        if (this.propertyfile == null) {
            throw new BuildException("propertyfile must be specified");
        }
        Properties properties = new Properties();
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
                File baseDir = ds.getBasedir();
                for (String file : ds.getIncludedFiles()) {
                    String hash = this.digest(baseDir, file, digester);
                    properties.put(file, hash);
                }
            }
            String comment = "Pregenerated static file version identifiers";
            if (this.maxHashLength > 0) {
                comment = comment + " - max length " + this.maxHashLength;
            }
            properties.store(new FileWriter(this.propertyfile), comment);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String digest(File baseDir, String file, MessageDigest digester) throws UnsupportedEncodingException, IOException {
        digester.reset();
        try (InputStream input = null;){
            input = new BufferedInputStream(new FileInputStream(new File(baseDir, file)), 8096);
            int read = 0;
            byte[] buffer = new byte[8096];
            while ((read = input.read(buffer)) > 0) {
                digester.update(buffer, 0, read);
            }
            if (StringUtils.hasText((String)this.salt)) {
                digester.update(this.salt.getBytes(StringUtils.DEFAULT_CHARSET));
            }
        }
        BigInteger integer = new BigInteger(digester.digest());
        if (integer.signum() == -1) {
            integer = integer.negate();
        }
        String hash = integer.toString();
        if (this.maxHashLength > 0 && hash.length() > this.maxHashLength) {
            hash = hash.substring(0, this.maxHashLength);
        }
        return hash;
    }
}

