/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.workingdays;

import java.io.IOException;
import java.io.InputStreamReader;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.workingdays.WorkingDaysHelper;

public class WorkingDaysHelperImpl
implements WorkingDaysHelper {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("ddMMyy");
    private Set<LocalDate> holidayDates = new HashSet<LocalDate>();

    public WorkingDaysHelperImpl() throws IOException {
        String source = StringUtils.copyToString(new InputStreamReader(this.getClass().getResourceAsStream("workingdays.txt")));
        StringTokenizer st = new StringTokenizer(source, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            LocalDate holiday = LocalDate.parse(line, DATE_FORMATTER);
            this.holidayDates.add(holiday);
        }
    }

    @Override
    public LocalDate datePlusWorkingDays(LocalDate start, int numWorkingDays) {
        int daysAdded = 0;
        LocalDate result = start;
        while (daysAdded < numWorkingDays) {
            if ((result = result.plusDays(1L)).getDayOfWeek().compareTo(DayOfWeek.FRIDAY) > 0 || this.holidayDates.contains(result)) continue;
            ++daysAdded;
        }
        return result;
    }

    @Override
    public int getNumWorkingDays(LocalDate first, LocalDate last) {
        boolean isNegative;
        LocalDate end;
        LocalDate start;
        if (last.isBefore(first)) {
            start = last;
            end = first;
            isNegative = true;
        } else {
            start = first;
            end = last;
            isNegative = false;
        }
        int numDays = 0;
        LocalDate temp = start;
        while (temp.isBefore(end) || temp.isEqual(end)) {
            if (temp.getDayOfWeek().compareTo(DayOfWeek.FRIDAY) <= 0 && !this.holidayDates.contains(temp)) {
                ++numDays;
            }
            temp = temp.plusDays(1L);
        }
        return isNegative ? -numDays : numDays;
    }

    @Override
    public Set<LocalDate> getHolidayDates() {
        return this.holidayDates;
    }

    @Override
    public void setHolidayDates(Set<LocalDate> holidayDates) {
        this.holidayDates = holidayDates;
    }
}

