/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view.json;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Configurable;
import uk.ac.warwick.util.web.spring.view.json.AbstractJSONView;
import uk.ac.warwick.util.web.spring.view.json.CompositeJSONPRequestValidator;
import uk.ac.warwick.util.web.spring.view.json.JSON;
import uk.ac.warwick.util.web.spring.view.json.JSONPRequestValidator;

@Configurable
public abstract class JSONView
extends AbstractJSONView<JSONObject> {
    @Override
    public final JSON<JSONObject> renderToJSON(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
        return JSON.wrap(this.render(model, request, errors));
    }

    public abstract JSONObject render(Map<String, Object> var1, HttpServletRequest var2, List<String> var3) throws Exception;

    public static JSONView combine(JSONView ... views) {
        return new CombinedJSONView(views);
    }

    public static JSONView of(JSONObject object, String charEncoding, JSONPRequestValidator jsonpValidator) {
        return JSONView.of(object, charEncoding, jsonpValidator, new String[0]);
    }

    public static JSONView of(JSONObject object, String charEncoding, JSONPRequestValidator jsonpValidator, String ... error) {
        return JSONView.of(object, charEncoding, jsonpValidator, Arrays.asList(error));
    }

    public static JSONView of(JSONObject object, String charEncoding, JSONPRequestValidator jsonpValidator, Iterable<String> error) {
        return new PreconfiguredJSONView(object, charEncoding, error, jsonpValidator);
    }

    public static JSONView errors(String charEncoding, JSONPRequestValidator jsonpValidator, String ... error) {
        return JSONView.errors(charEncoding, jsonpValidator, Arrays.asList(error));
    }

    public static JSONView errors(String charEncoding, JSONPRequestValidator jsonpValidator, Iterable<String> error) {
        return JSONView.of(new JSONObject(), charEncoding, jsonpValidator, error);
    }

    @Configurable
    public static class CombinedJSONView
    extends JSONView {
        private final Iterable<JSONView> views;

        public CombinedJSONView(JSONView ... theViews) {
            this((Iterable<JSONView>)ImmutableList.copyOf((Object[])theViews));
        }

        public CombinedJSONView(Iterable<JSONView> theViews) {
            this.views = theViews;
            this.setJsonpRequestValidator(new CompositeJSONPRequestValidator(Iterables.transform(theViews, (Function)new Function<JSONView, JSONPRequestValidator>(){

                public JSONPRequestValidator apply(JSONView view) {
                    return view.getJsonpRequestValidator();
                }
            })));
        }

        @Override
        public JSONObject render(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
            JSONObject combined = new JSONObject();
            for (JSONView view : this.views) {
                JSONObject object = view.render(model, request, errors);
                Iterator itr = object.keys();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    combined.put(key, object.get(key));
                }
            }
            return combined;
        }

        @Override
        public String getCharacterEncoding() {
            return this.views.iterator().next().getCharacterEncoding();
        }
    }

    @Configurable
    public static class PreconfiguredJSONView
    extends JSONView {
        private final JSONObject object;
        private final Iterable<String> errs;
        private final String characterEncoding;

        public PreconfiguredJSONView(JSONObject obj, String charEncoding, Iterable<String> err, JSONPRequestValidator jsonPValidator) {
            this.object = obj;
            this.errs = err;
            this.characterEncoding = charEncoding;
            this.setJsonpRequestValidator(jsonPValidator);
        }

        @Override
        public JSONObject render(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
            for (String err : this.errs) {
                errors.add(err);
            }
            return this.object;
        }

        @Override
        public String getCharacterEncoding() {
            return this.characterEncoding;
        }
    }
}

