/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.View;

public final class AlternateAjaxView
implements View {
    private static final String EXPECTED_HEADER_NAME = "X-Requested-With";
    private static final String EXPECTED_HEADER_VALUE = "XMLHttpRequest";
    private static final String PARAMETER = "ajax";
    private View standardView;
    private View ajaxView;
    private String contentType = "text/html";

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String requestedWith = request.getHeader(EXPECTED_HEADER_NAME);
        boolean override = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)PARAMETER, (boolean)false);
        boolean isAjax = override || requestedWith != null && requestedWith.contains(EXPECTED_HEADER_VALUE);
        model.put(PARAMETER, isAjax);
        if (isAjax) {
            this.ajaxView.render(model, request, response);
        } else {
            this.standardView.render(model, request, response);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public View getStandardView() {
        return this.standardView;
    }

    public void setStandardView(View standardView) {
        if (standardView == this) {
            throw new IllegalArgumentException("View was passed to itself");
        }
        this.standardView = standardView;
    }

    public View getAjaxView() {
        return this.ajaxView;
    }

    public void setAjaxView(View ajaxView) {
        if (ajaxView == this) {
            throw new IllegalArgumentException("View was passed to itself");
        }
        this.ajaxView = ajaxView;
    }
}

