/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view;

import com.google.common.collect.Maps;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.WireFeedOutput;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.ProcessingInstruction;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.View;

public abstract class AbstractXMLAggregationView<T extends WireFeed>
implements View {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, this.getCharacterEncoding());){
            WireFeedOutput output = new WireFeedOutput();
            T feed = this.getFeed(model, request);
            Document doc = output.outputJDom(feed);
            this.postProcess(doc);
            StringWriter sw = new StringWriter(4096);
            Format format = Format.getPrettyFormat();
            format.setEncoding(this.getCharacterEncoding());
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(doc, (Writer)sw);
            sw.flush();
            String encoded = this.postProcess(sw.toString());
            FileCopyUtils.copy((String)encoded, (Writer)writer);
            response.setContentType(this.getContentType() + "; charset=" + this.getCharacterEncoding());
            response.setContentLength(baos.size());
            ServletOutputStream out = response.getOutputStream();
            baos.writeTo((OutputStream)out);
            out.flush();
        }
    }

    public void postProcess(Document doc) {
    }

    public String postProcess(String input) {
        return input;
    }

    public abstract T getFeed(Map<String, Object> var1, HttpServletRequest var2) throws Exception;

    public abstract String getCharacterEncoding();

    public static final <T extends WireFeed> AbstractXMLAggregationView<T> of(T feed, String contentType) {
        return AbstractXMLAggregationView.of(feed, contentType, DEFAULT_CHARACTER_ENCODING);
    }

    public static final <T extends WireFeed> AbstractXMLAggregationView<T> of(final T feed, final String contentType, final String characterEncoding) {
        return new AbstractXMLAggregationView<T>(){

            @Override
            public T getFeed(Map<String, Object> model, HttpServletRequest request) throws Exception {
                return feed;
            }

            @Override
            public String getCharacterEncoding() {
                return characterEncoding;
            }

            public String getContentType() {
                return contentType;
            }
        };
    }

    protected final void addXslToDocument(Document doc, String path) {
        HashMap xsl = Maps.newHashMap();
        xsl.put("href", path);
        xsl.put("type", "text/xsl");
        xsl.put("media", "screen");
        ProcessingInstruction pXsl = new ProcessingInstruction("xml-stylesheet", (Map)xsl);
        doc.addContent(0, (Content)pXsl);
    }
}

