/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.ac.warwick.util.collections.google.BasePredicate;
import uk.ac.warwick.util.web.filter.stack.CompositeFilter;
import uk.ac.warwick.util.web.filter.stack.FilterMappingParser;

public final class FilterStackSet {
    private final ImmutableList<Filter> filters;
    private final ImmutableCollection<String> includedUrlPatterns;
    private final ImmutableCollection<String> excludedUrlPatterns;
    private final CompositeFilter compositeFilter;
    private final String name;
    private FilterMappingParser filterMappingParser;

    public FilterStackSet(List<Filter> tfilters, Collection<String> tincludedUrlPatterns) {
        this(tfilters, tincludedUrlPatterns, new ArrayList<String>());
    }

    public FilterStackSet(List<Filter> tfilters, Collection<String> tincludedUrlPatterns, Collection<String> texcludedUrlPatterns) {
        this(tfilters, tincludedUrlPatterns, texcludedUrlPatterns, null);
    }

    public FilterStackSet(List<Filter> tfilters, Collection<String> tincludedUrlPatterns, Collection<String> texcludedUrlPatterns, String tname) {
        this.filters = ImmutableList.copyOf(tfilters);
        this.compositeFilter = new CompositeFilter((List<Filter>)this.filters);
        this.includedUrlPatterns = ImmutableList.copyOf(tincludedUrlPatterns);
        this.excludedUrlPatterns = ImmutableList.copyOf(texcludedUrlPatterns);
        this.name = tname;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMatch(String urlPath) {
        BasePredicate<String> matcher = this.matcher(urlPath);
        return matcher.any((Iterable<String>)this.includedUrlPatterns) && !matcher.any((Iterable<String>)this.excludedUrlPatterns);
    }

    public void setFilterMappingParser(FilterMappingParser parser) {
        this.filterMappingParser = parser;
    }

    public CompositeFilter getCompositeFilter() {
        return this.compositeFilter;
    }

    private BasePredicate<String> matcher(final String urlPath) {
        return new BasePredicate<String>(){

            @Override
            public boolean apply(String pattern) {
                return FilterStackSet.this.filterMappingParser.matches(urlPath, pattern);
            }
        };
    }

    public static FilterStackSet merge(FilterStackSet first, List<FilterStackSet> others) {
        if (others.isEmpty()) {
            return first;
        }
        if (others.size() == 1) {
            return FilterStackSet.mergeTwo(first, others.get(0));
        }
        return FilterStackSet.merge(FilterStackSet.mergeTwo(first, others.get(0)), others.subList(1, others.size()));
    }

    private static FilterStackSet mergeTwo(FilterStackSet first, FilterStackSet second) {
        return new FilterStackSet(FilterStackSet.combineNoDuplicates(first.filters, second.filters), FilterStackSet.combineNoDuplicates(first.includedUrlPatterns, second.includedUrlPatterns), FilterStackSet.combineNoDuplicates(first.excludedUrlPatterns, second.excludedUrlPatterns), first.name);
    }

    private static <T> List<T> combineNoDuplicates(Collection<T> first, Collection<T> second) {
        ArrayList all = Lists.newArrayListWithCapacity((int)(first.size() + second.size()));
        all.addAll(first);
        for (T value : second) {
            FilterStackSet.addUnique(all, value);
        }
        return all;
    }

    private static <T> boolean addUnique(List<T> list, T value) {
        if (!list.contains(value)) {
            return list.add(value);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("filters", this.filters).append("includedUrls", this.includedUrlPatterns).append("excludedUrls", this.excludedUrlPatterns).append("name", (Object)this.name).build();
    }
}

