/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.web.filter.AbstractFilter;
import uk.ac.warwick.util.web.filter.RequestIPAddressHolder;
import uk.ac.warwick.util.web.filter.RequestIPAddressHolderImpl;

public final class RequestIPAddressFilter
extends AbstractFilter {
    public static final String CURRENT_IP_ATTRIBUTE = "REMOTE_IP_ADDRESS";
    public static final String CURRENT_IP_STRING_ATTRIBUTE = "REMOTE_IP_ADDRESS_STRING";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestIPAddressFilter.class);
    private final Collection<String> disallowedIpAddresses;

    public RequestIPAddressFilter(Collection<String> localIps) {
        this.disallowedIpAddresses = ImmutableSet.copyOf(localIps);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        RequestIPAddressHolderImpl requestIPAddressHolderImpl = new RequestIPAddressHolderImpl(req, this.disallowedIpAddresses);
        req.setAttribute(CURRENT_IP_ATTRIBUTE, (Object)requestIPAddressHolderImpl);
        req.setAttribute(CURRENT_IP_STRING_ATTRIBUTE, (Object)requestIPAddressHolderImpl.getNonLocalAddress());
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public static RequestIPAddressHolder get(HttpServletRequest request) {
        RequestIPAddressHolder holder = (RequestIPAddressHolder)request.getAttribute(CURRENT_IP_ATTRIBUTE);
        if (holder == null) {
            LOGGER.error("No RequestIPAddressHolder in request; not gone through RequestIPAddressFilter???");
            return new RequestIPAddressHolderImpl(request, Sets.newHashSet());
        }
        return holder;
    }
}

