/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.bind;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public abstract class AbstractPropertyEditor<T>
extends PropertyEditorSupport {
    private boolean allowEmpty;
    private boolean allowNotFound;

    public AbstractPropertyEditor() {
        this(true, false);
    }

    public AbstractPropertyEditor(boolean isAllowEmpty, boolean isAllowNotFound) {
        this.allowEmpty = isAllowEmpty;
        this.allowNotFound = isAllowNotFound;
    }

    @Override
    public final String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        return this.toString(object);
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)text)) {
            if (!this.allowEmpty) {
                throw new IllegalArgumentException();
            }
            super.setValue(null);
            return;
        }
        T object = this.fromString(text);
        if (object != null) {
            super.setValue(object);
        } else if (this.allowNotFound) {
            super.setValue(null);
        } else {
            throw new IllegalArgumentException("Could not find for " + text);
        }
    }

    public abstract String toString(T var1);

    public abstract T fromString(String var1);

    public final boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public final boolean isAllowNotFound() {
        return this.allowNotFound;
    }

    public final AbstractPropertyEditor<T> allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    public final AbstractPropertyEditor<T> nonEmpty() {
        this.allowEmpty = false;
        return this;
    }

    public final AbstractPropertyEditor<T> allowNotFound() {
        this.allowNotFound = true;
        return this;
    }

    public final AbstractPropertyEditor<T> mustExist() {
        this.allowNotFound = false;
        return this;
    }
}

