/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.virusscan.conf.play;

import com.typesafe.config.Config;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import uk.ac.warwick.util.virusscan.conf.Configuration;

@Singleton
public class TypesafeConfiguration
implements Configuration {
    private final Config config;

    @Inject
    public TypesafeConfiguration(@Named(value="virusScanConfig") Config typeSafeConfig) {
        this.config = typeSafeConfig;
    }

    @Override
    public String getApiHost() {
        return this.config.getString("virusscan.api.host");
    }

    @Override
    public String getApiKey() {
        return this.config.getString("virusscan.api.key");
    }

    @Override
    public boolean isEnabled() {
        if (!this.config.hasPath("virusscan.scan-uploads")) {
            return true;
        }
        return this.config.getBoolean("virusscan.scan-uploads");
    }

    @PostConstruct
    public void init() {
        this.validate();
    }
}

