/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.virusscan.conf;

import uk.ac.warwick.util.core.StringUtils;

public interface Configuration {
    public static final String API_HOST_PROPERTY = "virusscan.api.host";
    public static final String API_KEY_PROPERTY = "virusscan.api.key";
    public static final String SCAN_UPLOADS_PROPERTY = "virusscan.scan-uploads";
    public static final String DEFAULT_API_HOST = "https://virusscan.warwick.ac.uk";

    public String getApiHost();

    public String getApiKey();

    default public void validate() throws IllegalArgumentException {
        if (!StringUtils.hasText(this.getApiHost())) {
            throw new IllegalArgumentException("Virus scan API host not set - please check your configuration");
        }
        if (!StringUtils.hasText(this.getApiKey())) {
            throw new IllegalArgumentException("Virus scan API key not set - please check your configuration");
        }
    }

    public boolean isEnabled();
}

