/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates.legacy;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.termdates.legacy.Term;
import uk.ac.warwick.util.termdates.legacy.TermFactory;
import uk.ac.warwick.util.termdates.legacy.TermNotFoundException;

public final class TermImpl
implements Term {
    private final TermFactory termFactory;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final Term.TermType termType;

    public TermImpl(TermFactory factory, LocalDate start, LocalDate end, Term.TermType type) {
        this.termFactory = factory;
        this.startDate = start;
        this.endDate = end;
        this.termType = type;
    }

    @Override
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Override
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    public Term.TermType getTermType() {
        return this.termType;
    }

    @Override
    public String getTermTypeAsString() {
        String result;
        switch (this.termType) {
            case autumn: {
                result = "Autumn";
                break;
            }
            case spring: {
                result = "Spring";
                break;
            }
            case summer: {
                result = "Summer";
                break;
            }
            default: {
                throw new IllegalStateException("");
            }
        }
        return result;
    }

    @Override
    public int getWeekNumber(Temporal temporal) {
        LocalDate dt = LocalDate.from(temporal);
        LocalDate startOfFirstWeek = this.startDate.with(DayOfWeek.MONDAY);
        boolean firstDayOfTerm = DateTimeUtils.isSameDay(dt, startOfFirstWeek);
        if (dt.isBefore(startOfFirstWeek) && !firstDayOfTerm) {
            return -1;
        }
        int result = -2;
        LocalDate theWeek = startOfFirstWeek;
        for (int week = 1; week <= 10; ++week) {
            if (!dt.isBefore(theWeek = theWeek.plusWeeks(1L)) || DateTimeUtils.isSameDay(dt, theWeek)) continue;
            result = week;
            break;
        }
        return result;
    }

    @Override
    public int getCumulativeWeekNumber(Temporal dt) {
        int weekNumber = this.getWeekNumber(dt);
        if (weekNumber > 0) {
            switch (this.termType) {
                case autumn: {
                    break;
                }
                case summer: {
                    weekNumber += 10;
                }
                case spring: {
                    weekNumber += 10;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid term type: " + (Object)((Object)this.termType));
                }
            }
        }
        return weekNumber;
    }

    @Override
    public int getAcademicWeekNumber(Temporal temporal) {
        LocalDate dt = LocalDate.from(temporal);
        LocalDate start = null;
        LocalDate end = null;
        int result = 0;
        try {
            start = this.getAutumnTermStartDate(this, dt);
        }
        catch (TermNotFoundException e) {
            result = -1;
        }
        try {
            end = this.getBeforeNextAutumnTermDate(this);
        }
        catch (TermNotFoundException e) {
            result = -2;
        }
        if (result != 0 || start == null || end == null) {
            return result;
        }
        boolean firstDayOfTerm = DateTimeUtils.isSameDay(dt, start);
        if (dt.isBefore(start) && !firstDayOfTerm) {
            return -1;
        }
        result = -2;
        for (int week = 1; week <= 53; ++week) {
            if (!dt.isBefore(start = start.plusWeeks(1L)) || DateTimeUtils.isSameDay(dt, start)) continue;
            result = week;
            break;
        }
        return result;
    }

    private LocalDate getAutumnTermStartDate(Term t, Temporal dt) throws TermNotFoundException {
        Term autumnTerm = t;
        while (autumnTerm.getStartDate().isAfter(LocalDate.from(dt)) || autumnTerm.getTermType() != Term.TermType.autumn) {
            autumnTerm = this.termFactory.getPreviousTerm(autumnTerm);
        }
        return autumnTerm.getStartDate();
    }

    private LocalDate getBeforeNextAutumnTermDate(Term t) throws TermNotFoundException {
        Term nextAutumnTerm = t;
        while (nextAutumnTerm.getStartDate().equals(this.startDate) || nextAutumnTerm.getTermType() != Term.TermType.autumn) {
            nextAutumnTerm = this.termFactory.getNextTerm(nextAutumnTerm);
        }
        return nextAutumnTerm.getStartDate().minusWeeks(1L).with(DayOfWeek.SUNDAY);
    }
}

