/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates;

import com.google.common.collect.ImmutableList;
import java.time.Month;
import java.time.YearMonth;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import uk.ac.warwick.util.termdates.AcademicYear;
import uk.ac.warwick.util.termdates.AcademicYearPeriod;
import uk.ac.warwick.util.termdates.Term;
import uk.ac.warwick.util.termdates.TermDatesService;
import uk.ac.warwick.util.termdates.Vacation;

public class ExtendedAcademicYear
extends AcademicYear {
    private final ExtendedEndStrategy strategy;

    private ExtendedAcademicYear(int startYear, List<AcademicYearPeriod> periods, ExtendedEndStrategy strategy) {
        super(startYear, periods);
        this.strategy = strategy;
    }

    static ExtendedAcademicYear wrap(AcademicYear year, AcademicYear next, ExtendedEndStrategy strategy) {
        if (year.isPlaceholder() || next.isPlaceholder()) {
            return ExtendedAcademicYear.placeholder(year.getStartYear(), strategy);
        }
        ImmutableList.Builder periods = ImmutableList.builder();
        block4: for (AcademicYearPeriod period : year.getPeriods()) {
            if (period.getType() == AcademicYearPeriod.PeriodType.summerVacation) {
                switch (strategy) {
                    case StartOfAutumnTerm: {
                        periods.add((Object)Vacation.between(AcademicYearPeriod.PeriodType.summerVacation, (Term)year.getPeriod(AcademicYearPeriod.PeriodType.summerTerm), (Term)next.getPeriod(AcademicYearPeriod.PeriodType.autumnTerm)));
                        continue block4;
                    }
                    case EndOfAutumnTerm: {
                        periods.add((Object)Vacation.between(AcademicYearPeriod.PeriodType.summerVacation, (Term)year.getPeriod(AcademicYearPeriod.PeriodType.summerTerm), next.getPeriod(AcademicYearPeriod.PeriodType.autumnTerm).getLastDay()));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unexpected ExtendedEndStrategy " + (Object)((Object)strategy));
            }
            periods.add((Object)period);
        }
        return new ExtendedAcademicYear(year.getStartYear(), (List<AcademicYearPeriod>)periods.build(), strategy);
    }

    static ExtendedAcademicYear placeholder(int startYear, ExtendedEndStrategy strategy) {
        return new ExtendedAcademicYear(startYear, Collections.emptyList(), strategy);
    }

    public static ExtendedAcademicYear starting(int startYear) {
        return ExtendedAcademicYear.starting(startYear, ExtendedEndStrategy.StartOfAutumnTerm);
    }

    public static ExtendedAcademicYear starting(int startYear, ExtendedEndStrategy strategy) {
        return TermDatesService.INSTANCE.getExtendedAcademicYear(startYear, strategy);
    }

    public static ExtendedAcademicYear forDate(Temporal temporal) {
        return ExtendedAcademicYear.forDate(temporal, ExtendedEndStrategy.StartOfAutumnTerm);
    }

    public static ExtendedAcademicYear forDate(Temporal temporal, ExtendedEndStrategy strategy) {
        YearMonth yearMonth = YearMonth.from(temporal);
        return yearMonth.getMonthValue() < Month.AUGUST.getValue() ? ExtendedAcademicYear.starting(yearMonth.getYear() - 1, strategy) : ExtendedAcademicYear.starting(yearMonth.getYear(), strategy);
    }

    public static ExtendedAcademicYear parse(String pattern) {
        return ExtendedAcademicYear.parse(pattern, ExtendedEndStrategy.StartOfAutumnTerm);
    }

    public static ExtendedAcademicYear parse(String pattern, ExtendedEndStrategy strategy) {
        Matcher m = SITS_PATTERN.matcher(pattern);
        if (m.matches()) {
            int startYear = Integer.parseInt(m.group(1));
            return startYear > 90 ? ExtendedAcademicYear.starting(1900 + startYear, strategy) : ExtendedAcademicYear.starting(2000 + startYear, strategy);
        }
        throw new IllegalArgumentException("Did not match YY/YY: " + pattern);
    }

    @Override
    public ExtendedAcademicYear previous() {
        return ExtendedAcademicYear.starting(this.getStartYear() - 1, this.strategy);
    }

    @Override
    public ExtendedAcademicYear next() {
        return ExtendedAcademicYear.starting(this.getStartYear() + 1, this.strategy);
    }

    @Override
    public List<AcademicYear> yearsSurrounding(int yearsBefore, int yearsAfter) {
        ExtendedAcademicYear.verify(yearsBefore >= 0 && yearsAfter >= 0);
        ImmutableList.Builder years = ImmutableList.builder();
        for (int year = this.getStartYear() - yearsBefore; year <= this.getStartYear() + yearsAfter; ++year) {
            ExtendedAcademicYear yearToAdd = ExtendedAcademicYear.starting(year, this.strategy);
            years.add((Object)yearToAdd);
        }
        return years.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedAcademicYear that = (ExtendedAcademicYear)o;
        return super.equals(that) && this.strategy == that.strategy;
    }

    public static enum ExtendedEndStrategy {
        StartOfAutumnTerm,
        EndOfAutumnTerm;

    }
}

