/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.threeten.extra.LocalDateRange;
import uk.ac.warwick.util.termdates.AcademicYear;
import uk.ac.warwick.util.termdates.AcademicYearPeriod;

public class AcademicWeek
implements Comparable<AcademicWeek>,
Serializable {
    private final AcademicYear year;
    private final AcademicYearPeriod period;
    private final int weekNumber;
    private final LocalDateRange dateRange;

    private AcademicWeek(AcademicYear year, AcademicYearPeriod period, int weekNumber, LocalDateRange dateRange) {
        this.year = year;
        this.period = period;
        this.weekNumber = weekNumber;
        this.dateRange = dateRange;
    }

    static AcademicWeek of(AcademicYear academicYear, AcademicYearPeriod period, int weekNumber, LocalDateRange dateRange) {
        return new AcademicWeek(academicYear, period, weekNumber, dateRange);
    }

    public AcademicYear getYear() {
        return this.year;
    }

    public AcademicYearPeriod getPeriod() {
        return this.period;
    }

    public int getWeekNumber() {
        return this.weekNumber;
    }

    public int getTermWeekNumber() {
        if (!this.period.isTerm()) {
            throw new IllegalStateException();
        }
        int number = 1;
        LocalDate startDate = this.period.getFirstDay();
        while (!this.dateRange.contains(startDate)) {
            ++number;
            startDate = startDate.plusWeeks(1L);
        }
        return number;
    }

    public int getCumulativeWeekNumber() {
        int modifier;
        if (!this.period.isTerm()) {
            throw new IllegalStateException();
        }
        switch (this.period.getType()) {
            case springTerm: {
                modifier = 10;
                break;
            }
            case summerTerm: {
                modifier = 20;
                break;
            }
            default: {
                modifier = 0;
            }
        }
        return modifier + this.getTermWeekNumber();
    }

    public int getSitsWeekNumber() {
        LocalDate firstMondayInAugust = this.year.getPeriods().iterator().next().getFirstDay().with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY));
        LocalDate firstDayOfAutumnTerm = this.year.getPeriod(AcademicYearPeriod.PeriodType.autumnTerm).getFirstDay().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        int offset = (int)ChronoUnit.WEEKS.between(firstMondayInAugust, firstDayOfAutumnTerm);
        return this.weekNumber + offset;
    }

    public LocalDateRange getDateRange() {
        return this.dateRange;
    }

    @Override
    public int compareTo(AcademicWeek o) {
        int result = this.year.compareTo(o.year);
        if (result != 0) {
            return result;
        }
        result = this.period.compareTo(o.period);
        if (result != 0) {
            return result;
        }
        return this.weekNumber - o.weekNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcademicWeek that = (AcademicWeek)o;
        return new EqualsBuilder().append(this.weekNumber, that.weekNumber).append((Object)this.year, (Object)that.year).append((Object)this.period, (Object)that.period).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.year).append((Object)this.period).append(this.weekNumber).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("year", (Object)this.year).append("period", (Object)this.period).append("weekNumber", this.weekNumber).append("dateRange", (Object)this.dateRange).toString();
    }
}

