/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.service.healthchecks.scheduling;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.inject.Provider;
import javax.inject.Singleton;
import uk.ac.warwick.util.core.scheduling.QuartzDAO;
import uk.ac.warwick.util.core.scheduling.QuartzTrigger;
import uk.ac.warwick.util.service.ServiceHealthcheck;
import uk.ac.warwick.util.service.ServiceHealthcheckProvider;

@Singleton
public abstract class AbstractQuartzJobQueueHealthcheck
extends ServiceHealthcheckProvider {
    private static final String DEFAULT_NAME = "quartz-job-queue";
    private static final Duration DEFAULT_AGE_CRITICAL_THRESHOLD = Duration.ofHours(6L);
    private static final Duration DEFAULT_AGE_WARNING_THRESHOLD = Duration.ofHours(1L);
    private static final int DEFAULT_SIZE_CRITICAL_THRESHOLD = 300;
    private static final int DEFAULT_SIZE_WARNING_THRESHOLD = 75;
    private final QuartzDAO dao;
    private final Provider<String> schedulerNameProvider;
    private final String name;
    private Duration ageCriticalThreshold = DEFAULT_AGE_CRITICAL_THRESHOLD;
    private Duration ageWarningThreshold = DEFAULT_AGE_WARNING_THRESHOLD;
    private int sizeCriticalThreshold = 300;
    private int sizeWarningThreshold = 75;

    public AbstractQuartzJobQueueHealthcheck(String name, QuartzDAO dao, Provider<String> schedulerNameProvider) {
        super(new ServiceHealthcheck(name, ServiceHealthcheck.Status.Unknown, LocalDateTime.now()));
        this.name = name;
        this.dao = dao;
        this.schedulerNameProvider = schedulerNameProvider;
    }

    public AbstractQuartzJobQueueHealthcheck(QuartzDAO dao, Provider<String> schedulerNameProvider) {
        this(DEFAULT_NAME, dao, schedulerNameProvider);
    }

    protected final ServiceHealthcheck status() {
        String scheduler = (String)this.schedulerNameProvider.get();
        Collection<QuartzTrigger> pendingTriggers = this.dao.getPendingTriggers(scheduler);
        int totalTriggerCount = pendingTriggers.size();
        int errorTriggerCount = this.dao.countTriggerErrors(scheduler);
        Duration age = pendingTriggers.stream().sorted(Comparator.comparing(QuartzTrigger::getAge).reversed()).findFirst().map(trg -> Duration.ofMillis(trg.getAge())).orElse(Duration.ZERO);
        ServiceHealthcheck.Status status = errorTriggerCount > 0 ? ServiceHealthcheck.Status.Error : (age.compareTo(this.ageCriticalThreshold) >= 0 || totalTriggerCount >= this.sizeCriticalThreshold ? ServiceHealthcheck.Status.Error : (age.compareTo(this.ageWarningThreshold) >= 0 || totalTriggerCount >= this.sizeWarningThreshold ? ServiceHealthcheck.Status.Warning : ServiceHealthcheck.Status.Okay));
        String message = errorTriggerCount == 0 && age.isZero() && totalTriggerCount == 0 ? "No outstanding jobs in queue" : (errorTriggerCount > 0 ? errorTriggerCount + (errorTriggerCount > 1 ? " jobs" : " job") + " in error; " : "") + totalTriggerCount + (totalTriggerCount != 1 ? " jobs" : " job") + " in queue for cluster " + scheduler + " (warn: " + this.sizeWarningThreshold + ", crit: " + this.sizeCriticalThreshold + "); last job is " + age.toMinutes() + " minutes old (warn: " + this.ageWarningThreshold.toMinutes() + ", crit: " + this.ageCriticalThreshold.toMinutes() + ")";
        return new ServiceHealthcheck(this.name, status, LocalDateTime.now(), message, Arrays.asList(new ServiceHealthcheck.PerformanceData<Long>("mins_old", age.toMinutes(), this.ageWarningThreshold.toMinutes(), this.ageCriticalThreshold.toMinutes()), new ServiceHealthcheck.PerformanceData<Integer>("queue_depth", totalTriggerCount, this.sizeWarningThreshold, this.sizeCriticalThreshold), new ServiceHealthcheck.PerformanceData<Integer>("failed_jobs", errorTriggerCount, 1, 1)));
    }

    public void setAgeCriticalThreshold(Duration ageCriticalThreshold) {
        this.ageCriticalThreshold = ageCriticalThreshold;
    }

    public void setAgeWarningThreshold(Duration ageWarningThreshold) {
        this.ageWarningThreshold = ageWarningThreshold;
    }

    public void setSizeCriticalThreshold(int sizeCriticalThreshold) {
        this.sizeCriticalThreshold = sizeCriticalThreshold;
    }

    public void setSizeWarningThreshold(int sizeWarningThreshold) {
        this.sizeWarningThreshold = sizeWarningThreshold;
    }
}

