/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Set;
import javax.validation.constraints.NotNull;
import uk.ac.warwick.userlookup.GroupService;
import uk.ac.warwick.userlookup.UserLookupInterface;
import uk.ac.warwick.userlookup.webgroups.GroupNotFoundException;
import uk.ac.warwick.userlookup.webgroups.GroupServiceException;

public interface ValidRecipients {
    public Set<String> getUsers();

    public Set<String> getGroups();

    @JsonIgnore
    default public boolean isValid() {
        Set<String> users = this.getUsers();
        Set<String> groups = this.getGroups();
        boolean isValid = (!users.isEmpty() || !groups.isEmpty()) && this.isValid(users) && this.isValid(groups);
        return isValid;
    }

    default public boolean isValid(@NotNull UserLookupInterface userLookupInterface) {
        return this.isValid() && this.getUsers().stream().allMatch(e -> this.isValid(userLookupInterface, (String)e));
    }

    default public boolean isValid(@NotNull GroupService groupService) {
        return this.isValid() && this.getGroups().stream().allMatch(e -> this.isValid(groupService, (String)e));
    }

    default public boolean isValid(@NotNull UserLookupInterface userLookupInterface, @NotNull GroupService groupService) {
        return this.isValid(userLookupInterface) && this.isValid(groupService);
    }

    default public boolean isValid(@NotNull UserLookupInterface userLookupInterface, String userId) {
        return userLookupInterface.getUserByWarwickUniId(userId, false).isFoundUser();
    }

    default public boolean isValid(@NotNull GroupService groupService, String groupName) {
        try {
            return groupService.getGroupByName(groupName) != null;
        }
        catch (GroupNotFoundException | GroupServiceException e) {
            return false;
        }
    }

    default public boolean isValid(String text) {
        return text != null && !text.isEmpty() && !text.contains(" ");
    }

    default public boolean isValid(Set<String> texts) {
        return texts.stream().allMatch(this::isValid);
    }
}

