/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model;

import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;

abstract class AbstractSpringConfiguration
implements Configuration {
    protected final Properties defaults = Configuration.loadDefaults();
    private Set<Instance> instanceSet;

    protected String getOrDefault(String key) {
        String value = this.getOrNull(key);
        if (value == null) {
            return this.defaults.getProperty(key);
        }
        return value;
    }

    protected abstract String getOrNull(String var1);

    abstract boolean keyExists(String var1);

    private void initMyWarwickConfigs() {
        Optional<Integer> firstMissingIndex = Stream.iterate(0, i -> i + 1).filter(i -> !this.keyExists("mywarwick.instances." + i + ".providerId")).findFirst();
        if (!firstMissingIndex.isPresent()) {
            throw new IllegalArgumentException("No instances found under mywarwick.instances.*");
        }
        int instances = firstMissingIndex.get();
        this.instanceSet = Stream.iterate(0, i -> i + 1).limit(instances).map(i -> {
            String prefix = "mywarwick.instances." + i;
            return new Instance(this.getOrNull(prefix + ".baseUrl"), this.getOrNull(prefix + ".providerId"), this.getOrNull(prefix + ".userName"), this.getOrNull(prefix + ".password"), this.getOrNull(prefix + ".logErrors"));
        }).collect(Collectors.toSet());
    }

    @Override
    public Set<Instance> getInstances() {
        if (this.instanceSet == null) {
            this.instanceSet = new HashSet<Instance>();
            this.initMyWarwickConfigs();
        }
        return this.instanceSet;
    }

    @Override
    public int getHttpMaxConn() {
        return Integer.parseInt(this.getOrDefault("mywarwick.http.maxConn"));
    }

    @Override
    public int getHttpMaxConnPerRoute() {
        return Integer.parseInt(this.getOrDefault("mywarwick.http.maxConnPerRoute"));
    }

    @Override
    public String getQuartzHealthcheckName() {
        return this.getOrDefault("mywarwick.quartz.healthcheck.name");
    }

    @Override
    public long getQuartzHealthcheckQueueSizeWarningThreshold() {
        return Long.parseLong(this.getOrDefault("mywarwick.quartz.healthcheck.queueSize.warning"));
    }

    @Override
    public long getQuartzHealthcheckQueueSizeCriticalThreshold() {
        return Long.parseLong(this.getOrDefault("mywarwick.quartz.healthcheck.queueSize.critical"));
    }

    @Override
    public Duration getQuartzHealthcheckDelayWarningThreshold() {
        return Duration.parse(this.getOrDefault("mywarwick.quartz.healthcheck.delay.warning"));
    }

    @Override
    public Duration getQuartzHealthcheckDelayCriticalThreshold() {
        return Duration.parse(this.getOrDefault("mywarwick.quartz.healthcheck.delay.critical"));
    }
}

