/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.healthcheck;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.mywarwick.SendMyWarwickActivityJob;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.service.ServiceHealthcheck;
import uk.ac.warwick.util.service.ServiceHealthcheckProvider;

@Singleton
public abstract class AbstractMyWarwickQuartzHealthcheckProvider
extends ServiceHealthcheckProvider {
    static final long INITIAL_DELAY_MS = 0L;
    static final long RUN_INTERVAL_MS = 60000L;
    private final Scheduler scheduler;
    private final String name;
    private final long queueSizeWarningThreshold;
    private final long queueSizeCriticalThreshold;
    private final Duration delayWarningThreshold;
    private final Duration delayCriticalThreshold;

    @Inject
    public AbstractMyWarwickQuartzHealthcheckProvider(Scheduler scheduler, Configuration configuration) {
        super(new ServiceHealthcheck(configuration.getQuartzHealthcheckName(), ServiceHealthcheck.Status.Unknown, LocalDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION)));
        this.scheduler = scheduler;
        this.name = configuration.getQuartzHealthcheckName();
        this.queueSizeWarningThreshold = configuration.getQuartzHealthcheckQueueSizeWarningThreshold();
        this.queueSizeCriticalThreshold = configuration.getQuartzHealthcheckQueueSizeCriticalThreshold();
        this.delayWarningThreshold = configuration.getQuartzHealthcheckDelayWarningThreshold();
        this.delayCriticalThreshold = configuration.getQuartzHealthcheckDelayCriticalThreshold();
    }

    @Override
    public void run() {
        try {
            List triggers = this.scheduler.getTriggersOfJob(SendMyWarwickActivityJob.JOB_KEY);
            long queueSize = 0L;
            OffsetDateTime oldestNotification = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION);
            for (Trigger trigger : triggers) {
                OffsetDateTime createdDateTime;
                String createdDateTimeISO8601;
                Trigger.TriggerState triggerState = this.scheduler.getTriggerState(trigger.getKey());
                if (triggerState == Trigger.TriggerState.NORMAL) {
                    ++queueSize;
                }
                if (triggerState == Trigger.TriggerState.COMPLETE || (createdDateTimeISO8601 = trigger.getJobDataMap().getString("createdDateTimeISO8601")) == null || !(createdDateTime = OffsetDateTime.parse(createdDateTimeISO8601)).isBefore(oldestNotification)) continue;
                oldestNotification = createdDateTime;
            }
            OffsetDateTime delayCriticalThresholdDT = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).minus(this.delayCriticalThreshold);
            OffsetDateTime delayWarningThresholdDT = OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).minus(this.delayWarningThreshold);
            ServiceHealthcheck.Status status = queueSize >= this.queueSizeCriticalThreshold || oldestNotification.isBefore(delayCriticalThresholdDT) ? ServiceHealthcheck.Status.Error : (queueSize >= this.queueSizeWarningThreshold || oldestNotification.isBefore(delayWarningThresholdDT) ? ServiceHealthcheck.Status.Warning : ServiceHealthcheck.Status.Okay);
            String message = queueSize == 0L ? "No queued activities" : String.format("%d queued My Warwick activities%s; oldest activity %d minutes old%s", queueSize, queueSize >= this.queueSizeCriticalThreshold ? " (!!)" : (queueSize >= this.queueSizeWarningThreshold ? " (!)" : ""), ChronoUnit.MINUTES.between(oldestNotification, OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION)), oldestNotification.isBefore(delayCriticalThresholdDT) ? " (!!)" : (oldestNotification.isBefore(delayWarningThresholdDT) ? " (!)" : ""));
            this.update(new ServiceHealthcheck(this.name, status, LocalDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION), message, Arrays.asList(new ServiceHealthcheck.PerformanceData<Long>("queue_size", queueSize, this.queueSizeWarningThreshold, this.queueSizeCriticalThreshold), new ServiceHealthcheck.PerformanceData<Long>("delay_minutes", ChronoUnit.MINUTES.between(oldestNotification, OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION)), this.delayWarningThreshold.toMinutes(), this.delayCriticalThreshold.toMinutes()))));
        }
        catch (SchedulerException e) {
            this.update(new ServiceHealthcheck(this.name, ServiceHealthcheck.Status.Unknown, LocalDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION), "Unable to get My Warwick activity queue information; " + e.getMessage()));
        }
    }
}

