/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mail;

import org.apache.commons.validator.routines.EmailValidator;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import uk.ac.warwick.util.core.StringUtils;

public final class EmailAddressChecker {
    private static final EmailValidator VALIDATOR = EmailValidator.getInstance();
    private boolean empty;
    private boolean matches;
    private boolean serverError = false;

    public EmailAddressChecker(String email) {
        if (!StringUtils.hasText(email)) {
            this.empty = true;
            this.matches = false;
        } else {
            this.empty = false;
            if (VALIDATOR.isValid(email)) {
                try {
                    String domain = email.substring(email.lastIndexOf("@") + 1).trim();
                    Lookup mxLookup = new Lookup(domain, 15);
                    Record[] records = mxLookup.run();
                    this.handleServerError(mxLookup);
                    if (records == null) {
                        Lookup aLookup = new Lookup(domain, 1);
                        records = aLookup.run();
                        this.handleServerError(aLookup);
                    }
                    this.matches = records != null;
                }
                catch (TextParseException e) {
                    this.matches = false;
                }
            }
        }
    }

    private void handleServerError(Lookup mxLookup) {
        if (mxLookup.getResult() == 2 || mxLookup.getResult() == 1) {
            this.serverError = true;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isValid() {
        return !this.empty && (this.matches || this.serverError);
    }

    public boolean isMatches() {
        return this.matches;
    }

    public boolean isServerError() {
        return this.serverError;
    }
}

