/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.httpclient.httpclient4.DefaultHttpRequestDecorator;
import uk.ac.warwick.util.httpclient.httpclient4.HttpClientFactory;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.HttpRequestDecorator;
import uk.ac.warwick.util.httpclient.httpclient4.MultiThreadedHttpClientFactory;
import uk.ac.warwick.util.web.Uri;

public abstract class AbstractHttpMethodExecutor
implements HttpMethodExecutor {
    private static final long serialVersionUID = -6884588480427697793L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpMethodExecutor.class);
    private HttpRequestBase request;
    private Uri requestUrl;
    private final HttpMethodExecutor.Method methodType;
    private final List<Header> headers = Lists.newArrayList();
    private List<? extends NameValuePair> postBody;
    private List<Pair<String, ? extends ContentBody>> multipartBody;
    private JSONObject jsonBody;
    private int connectionTimeout = 5000;
    private int retrievalTimeout = 5000;
    private HttpClientFactory factory = MultiThreadedHttpClientFactory.getInstance();
    private final HttpContext context = new BasicHttpContext();
    private HttpResponse response;
    private HttpRequestDecorator httpRequestDecorator = new DefaultHttpRequestDecorator();
    private boolean followRedirects;
    private boolean followRedirectsSet;
    private boolean http10Only;
    private boolean useExpect = true;
    private boolean useExpectSet;

    public AbstractHttpMethodExecutor(HttpMethodExecutor.Method method) {
        this(method, null);
    }

    public AbstractHttpMethodExecutor(HttpMethodExecutor.Method method, Uri requestUrl) {
        this.methodType = method;
        this.requestUrl = requestUrl;
    }

    @Override
    public final <T> Pair<Integer, T> execute(ResponseHandler<T> responseHandler) throws IOException {
        this.assertNotExecuted();
        this.createRequest();
        RequestConfig.Builder configBuilder = RequestConfig.copy((RequestConfig)this.request.getConfig());
        if (this.connectionTimeout > 0) {
            configBuilder.setConnectionRequestTimeout(this.connectionTimeout);
            configBuilder.setConnectTimeout(this.connectionTimeout);
        }
        if (this.retrievalTimeout > 0) {
            configBuilder.setSocketTimeout(this.retrievalTimeout);
        }
        this.request.setConfig(configBuilder.build());
        try {
            this.httpRequestDecorator.decorate((HttpUriRequest)this.request, this.context);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            Pair response = (Pair)this.factory.getClient().execute((HttpUriRequest)this.request, response1 -> Pair.of(response1, Pair.of(response1.getStatusLine().getStatusCode(), responseHandler.handleResponse(response1))), this.context);
            this.response = (HttpResponse)response.getLeft();
            return (Pair)response.getRight();
        }
        catch (ConnectionPoolTimeoutException e) {
            this.poolExceptionLogging(e);
            throw e;
        }
    }

    @Override
    public final int execute(HttpMethodExecutor.StreamCallback callback) throws IOException {
        return this.execute(response -> {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                callback.doWithStream(entity.getContent());
            }
            return null;
        }).getLeft();
    }

    private HttpRequestBase createRequestForMethod() {
        HttpGet r;
        switch (this.methodType) {
            case get: {
                r = new HttpGet(this.parseRequestUrl(this.requestUrl).toJavaUri());
                break;
            }
            case head: {
                r = new HttpHead(this.parseRequestUrl(this.requestUrl).toJavaUri());
                break;
            }
            case put: {
                r = new HttpPut(this.parseRequestUrl(this.requestUrl).toJavaUri());
                break;
            }
            case patch: {
                r = new HttpPatch(this.parseRequestUrl(this.requestUrl).toJavaUri());
                break;
            }
            case post: {
                r = new HttpPost(this.parseRequestUrl(this.requestUrl).toJavaUri());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported request type: " + (Object)((Object)this.methodType));
            }
        }
        return r;
    }

    private void createRequest() {
        this.request = this.createRequestForMethod();
        if (this.methodType.hasBody()) {
            UrlEncodedFormEntity entity;
            HttpEntityEnclosingRequestBase r = (HttpEntityEnclosingRequestBase)this.request;
            if (this.multipartBody != null && !this.multipartBody.isEmpty()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                for (Pair<String, ? extends ContentBody> multipart : this.multipartBody) {
                    builder.addPart(multipart.getLeft(), multipart.getRight());
                }
                r.setEntity(builder.build());
            } else if (this.postBody != null) {
                try {
                    entity = new UrlEncodedFormEntity(this.postBody, "UTF-8");
                    r.setEntity((HttpEntity)entity);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            } else if (this.jsonBody != null) {
                entity = new StringEntity(this.jsonBody.toString(), ContentType.APPLICATION_JSON);
                r.setEntity((HttpEntity)entity);
            }
        }
        RequestConfig.Builder configBuilder = RequestConfig.copy((RequestConfig)MultiThreadedHttpClientFactory.DEFAULT_REQUEST_CONFIG);
        if (this.followRedirectsSet) {
            configBuilder.setRedirectsEnabled(this.followRedirects);
        }
        if (this.http10Only) {
            this.request.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        }
        if (this.useExpectSet) {
            configBuilder.setExpectContinueEnabled(this.useExpect);
        }
        this.request.setConfig(configBuilder.build());
        for (Header header : this.headers) {
            this.request.addHeader(header);
        }
    }

    private void poolExceptionLogging(ConnectionPoolTimeoutException e) {
        if (this.factory instanceof MultiThreadedHttpClientFactory) {
            PoolingHttpClientConnectionManager cm = ((MultiThreadedHttpClientFactory)this.factory).getConnectionManager();
            String scheme = this.request.getURI().getScheme();
            int port = this.request.getURI().getPort();
            if (port < 0) {
                if ("http".equalsIgnoreCase(scheme)) {
                    port = 80;
                } else if ("https".equalsIgnoreCase(scheme)) {
                    port = 443;
                }
            }
            HttpRoute route = new HttpRoute(new HttpHost(this.request.getURI().getHost(), port, scheme), this.request.getConfig().getLocalAddress(), "https".equalsIgnoreCase(scheme));
            PoolStats totals = cm.getTotalStats();
            PoolStats stats = cm.getStats(route);
            LOGGER.error(String.format("%s [route: %s] [total kept alive: %d; route allocated: %d of %d; total allocated: %d of %d]", e.getMessage(), route, totals.getAvailable(), stats.getLeased() + stats.getAvailable(), stats.getMax(), totals.getLeased() + totals.getAvailable(), totals.getMax()), (Throwable)e);
        }
    }

    public abstract Uri parseRequestUrl(Uri var1);

    public final HttpRequestDecorator getHttpRequestDecorator() {
        return this.httpRequestDecorator;
    }

    @Override
    public final void setHttpRequestDecorator(HttpRequestDecorator httpRequestDecorator) {
        this.httpRequestDecorator = httpRequestDecorator;
    }

    @Override
    public final void addHeader(String name, String value) {
        this.assertNotExecuted();
        this.addHeader((Header)new BasicHeader(name, value));
    }

    @Override
    public final void addHeader(Header header) {
        this.assertNotExecuted();
        this.headers.add(header);
    }

    @Override
    public final void setConnectionTimeout(int timeout) {
        this.assertNotExecuted();
        this.connectionTimeout = timeout;
    }

    @Override
    public final void setRetrievalTimeout(int timeout) {
        this.assertNotExecuted();
        this.retrievalTimeout = timeout;
    }

    @Override
    public final void setHttpClientFactory(HttpClientFactory factory) {
        this.assertNotExecuted();
        this.factory = factory;
    }

    @Override
    public final void setMultipartBody(List<Pair<String, ? extends ContentBody>> body) {
        this.assertNotExecuted();
        this.multipartBody = body;
    }

    @Override
    public final void setPostBody(List<? extends NameValuePair> postBody) {
        this.assertNotExecuted();
        this.postBody = postBody;
    }

    @Override
    public final void setJsonBody(JSONObject json) {
        this.assertNotExecuted();
        this.jsonBody = json;
    }

    @Override
    public final List<? extends NameValuePair> getPostBody() {
        return this.postBody;
    }

    @Override
    public final List<Pair<String, ? extends ContentBody>> getMultipartBody() {
        return this.multipartBody;
    }

    @Override
    public JSONObject getJsonBody() {
        return this.jsonBody;
    }

    @Override
    public void setUrl(Uri url) {
        this.assertNotExecuted();
        this.requestUrl = url;
    }

    @Override
    public final void setUrl(String url) {
        this.assertNotExecuted();
        this.requestUrl = AbstractHttpMethodExecutor.parse(url);
    }

    protected static Uri parse(String uri) {
        if (uri == null) {
            return null;
        }
        return Uri.parse(uri);
    }

    @Override
    public final String getUrl() {
        if (this.response == null) {
            return this.requestUrl.toString();
        }
        return this.getRedirectUrl();
    }

    @Override
    public final HttpContext getContext() {
        return this.context;
    }

    @Override
    public final HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public final String getHeader(String name) {
        this.assertExecuted();
        Header header = this.response.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public final Date getLastModifiedDate() {
        this.assertExecuted();
        Header lastModifiedHeader = this.response.getFirstHeader("Last-Modified");
        Date result = null;
        if (lastModifiedHeader != null) {
            String value = lastModifiedHeader.getValue();
            result = DateUtils.parseDate((String)value);
        }
        return result;
    }

    @Override
    public final String getRedirectUrl() {
        this.assertExecuted();
        return this.getUri().toString();
    }

    @Override
    public final Uri getUri() {
        this.assertExecuted();
        HttpUriRequest finalRequest = (HttpUriRequest)this.context.getAttribute("http.request");
        HttpHost currentHost = (HttpHost)this.context.getAttribute("http.target_host");
        if (finalRequest != null && finalRequest.getURI().isAbsolute()) {
            return Uri.fromJavaUri(finalRequest.getURI());
        }
        if (finalRequest != null && currentHost != null) {
            return Uri.parse(currentHost.toURI()).resolve(Uri.fromJavaUri(finalRequest.getURI()));
        }
        throw new IllegalStateException("Couldn't find target in context");
    }

    private void assertNotExecuted() {
        if (this.response != null) {
            throw new IllegalStateException("Request has already been executed");
        }
    }

    private void assertExecuted() {
        if (this.response == null) {
            throw new IllegalStateException("Request has not yet been executed");
        }
    }

    @Override
    public void setFollowRedirects(boolean follow) {
        this.followRedirectsSet = true;
        this.followRedirects = follow;
    }

    @Override
    public void setHttp10Only(boolean http1) {
        this.http10Only = http1;
    }

    @Override
    public void setUseExpectContinueHeader(boolean expect) {
        this.useExpectSet = true;
        this.useExpect = expect;
    }
}

