/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractFileBackedFileData;
import uk.ac.warwick.util.files.impl.AbstractFileReference;

public final class FileBackedHashFileReference
extends AbstractFileReference
implements HashFileReference {
    private final HashFileStore fileStore;
    private final Data data;
    private File file;
    private HashString hash;

    public FileBackedHashFileReference(HashFileStore store, File backingFile, HashString theHash) {
        this.fileStore = store;
        this.file = backingFile;
        this.hash = theHash;
        this.data = new Data();
    }

    @Override
    public HashString getHash() {
        return this.hash;
    }

    @Override
    public String getPath() {
        return null;
    }

    private void update(File backingFile, HashString theHash) {
        this.file = backingFile;
        this.hash = theHash;
    }

    @Override
    public HashFileReference copyTo(FileReference target) throws IOException {
        return new FileBackedHashFileReference(this.fileStore, this.file, this.hash);
    }

    @Override
    public HashFileReference renameTo(FileReference target) throws IOException {
        return this;
    }

    @Override
    public FileData<FileReference> getData() {
        return this.data;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.hash + " (" + this.data.toString() + ")";
    }

    @Override
    public void unlink() {
    }

    class Data
    extends AbstractFileBackedFileData {
        private Data() {
            super(FileBackedHashFileReference.this.fileStore);
        }

        @Override
        public File getFile() {
            return FileBackedHashFileReference.this.file;
        }

        public HashFileReference overwrite(ByteSource in) throws IOException {
            HashFileReference newReference = FileBackedHashFileReference.this.fileStore.createHashReference(in, FileBackedHashFileReference.this.getHash().getStoreName());
            FileBackedHashFileReference.this.update(new File(newReference.getFileLocation().getPath()), newReference.getHash());
            return newReference;
        }
    }
}

