/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.time.Instant;
import org.apache.commons.io.FilenameUtils;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import uk.ac.warwick.util.core.spring.FileUtils;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractBlobBackedFileData;
import uk.ac.warwick.util.files.impl.AbstractFileReference;
import uk.ac.warwick.util.files.impl.BlobStoreFileStore;

public final class BlobBackedLocalFileReference
extends AbstractFileReference
implements LocalFileReference {
    private final BlobStore blobStore;
    private final String containerName;
    private final Data data;
    private final String path;
    private final BlobStoreFileStore fileStore;
    private final Storeable.StorageStrategy storageStrategy;

    public BlobBackedLocalFileReference(BlobStoreFileStore store, BlobStore blobStore, String containerName, String thepath, Storeable.StorageStrategy theStorageStrategy) {
        this.fileStore = store;
        this.blobStore = blobStore;
        this.containerName = containerName;
        this.path = FilenameUtils.separatorsToUnix((String)thepath);
        this.data = new Data();
        this.storageStrategy = theStorageStrategy;
    }

    @Override
    public FileData<FileReference> getData() {
        return this.data;
    }

    @Override
    public String getFileName() {
        return FileUtils.getFileName(this.path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public HashString getHash() {
        return null;
    }

    @Override
    public LocalFileReference copyTo(FileReference target) throws IOException {
        return this.copyTo(target.toLocalReference().getPath());
    }

    @Override
    public LocalFileReference copyTo(String newPath) throws IOException {
        this.fileStore.statistics.timeSafe(() -> this.blobStore.copyBlob(this.containerName, this.path, this.containerName, newPath, CopyOptions.NONE), this.fileStore.statistics::referenceWritten);
        return new BlobBackedLocalFileReference(this.fileStore, this.blobStore, this.containerName, newPath, this.storageStrategy);
    }

    @Override
    public LocalFileReference renameTo(FileReference target) throws IOException {
        return this.renameTo(target.toLocalReference().getPath());
    }

    @Override
    public LocalFileReference renameTo(String newPath) throws IOException {
        LocalFileReference renamed = this.copyTo(newPath);
        this.unlink();
        return renamed;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Instant getLastModified() {
        return this.data.getLastModified();
    }

    @Override
    public Storeable.StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getPath() + " (" + this.data.toString() + ")";
    }

    @Override
    public void unlink() {
        this.getData().delete();
    }

    class Data
    extends AbstractBlobBackedFileData {
        private Data() {
            super(BlobBackedLocalFileReference.this.fileStore, BlobBackedLocalFileReference.this.blobStore, BlobBackedLocalFileReference.this.containerName, BlobBackedLocalFileReference.this.path);
        }

        public LocalFileReference overwrite(ByteSource in) throws IOException {
            BlobBackedLocalFileReference thisReference = BlobBackedLocalFileReference.this;
            BlobBackedLocalFileReference.this.fileStore.doStore(in, BlobBackedLocalFileReference.this.path, BlobBackedLocalFileReference.this.containerName, thisReference);
            this.byteSource.invalidate();
            return thisReference;
        }

        Instant getLastModified() {
            return this.byteSource.getLastModified();
        }
    }
}

