/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public final class CachePolicy {
    public static final Duration IMAGE_CACHE_PERIOD = Duration.ofHours(2L);
    public static final CachePolicy PUBLIC_IMAGES = CachePolicy.publicCaching(IMAGE_CACHE_PERIOD);
    public static final Duration SITE_ASSET_CACHE_PERIOD = Duration.ofDays(365L);
    public static final CachePolicy SITE_ASSET = CachePolicy.publicCaching(SITE_ASSET_CACHE_PERIOD);
    public static final CachePolicy PUBLIC = CachePolicy.publicCaching();
    public static final CachePolicy PRIVATE = CachePolicy.privateCaching();
    public static final CachePolicy NO_POLICY = CachePolicy.noPolicy();
    private final Privacy privacy;
    private final Duration expiresPeriod;
    private final boolean noCache;

    private CachePolicy(Privacy privacyPolicy, Duration expiry, boolean isNoCache) {
        this.privacy = privacyPolicy;
        this.expiresPeriod = expiry;
        this.noCache = isNoCache;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public Duration getExpiresPeriod() {
        return this.expiresPeriod;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    private static CachePolicy publicCaching() {
        return CachePolicy.publicCaching(null);
    }

    private static CachePolicy publicCaching(Duration expires) {
        return CachePolicy.publicCaching(expires, false);
    }

    private static CachePolicy publicCaching(Duration expires, boolean noCache) {
        return new CachePolicy(Privacy.Public, expires, noCache);
    }

    private static CachePolicy privateCaching() {
        return CachePolicy.privateCaching(null);
    }

    private static CachePolicy privateCaching(Duration expires) {
        return CachePolicy.privateCaching(expires, false);
    }

    private static CachePolicy privateCaching(Duration expires, boolean noCache) {
        return new CachePolicy(Privacy.Private, expires, noCache);
    }

    private static CachePolicy noPolicy() {
        return new CachePolicy(null, null, false);
    }

    public String toString() {
        ArrayList components = Lists.newArrayList();
        if (this.noCache) {
            components.add("no-cache");
        }
        if (this.privacy != null) {
            components.add(this.privacy.cacheControlString);
        }
        if (this.expiresPeriod != null) {
            components.add("max-age=" + this.expiresPeriod.getSeconds());
            components.add("stale-while-revalidate=60");
        } else if (this.privacy != null) {
            components.add("max-age=0");
        }
        return StringUtils.join((Iterable)components, (String)", ");
    }

    private static enum Privacy {
        Public("public"),
        Private("private");

        private String cacheControlString;

        private Privacy(String ccs) {
            this.cacheControlString = ccs;
        }
    }
}

