/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash.impl;

import org.apache.commons.codec.digest.DigestUtils;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.files.hash.MessageAuthenticationCodeGenerator;

public final class SHAAuthenticationCodeGenerator
implements MessageAuthenticationCodeGenerator {
    private final String salt;

    public SHAAuthenticationCodeGenerator(String theSalt) {
        this.salt = theSalt;
    }

    @Override
    public String generateMessageAuthenticationCode(String urlParams) {
        if (!this.isValidSalt()) {
            return null;
        }
        String concatenatedValues = urlParams.concat(this.salt);
        return this.getSHAHash(concatenatedValues);
    }

    private String getSHAHash(String input) {
        return DigestUtils.shaHex((String)input);
    }

    @Override
    public boolean isValidSalt() {
        return StringUtils.hasText(this.salt);
    }
}

