/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.FileBackedHashFileReference;

public final class FileSystemBackedHashResolver
implements FileHashResolver {
    private final File storeLocation;
    private final String storeName;
    private final FileHasher hasher;
    private final HashInfoDAO dao;
    private final MaintenanceModeFlags flags;

    public FileSystemBackedHashResolver(FileHasher theHasher, String name, File location, HashInfoDAO sbd, MaintenanceModeFlags f) {
        this.hasher = theHasher;
        this.storeName = name;
        this.storeLocation = location;
        this.dao = sbd;
        this.flags = f;
    }

    @Override
    public boolean exists(HashString hashString) {
        if (!this.belongsToUs(hashString)) {
            throw new IllegalArgumentException("HashString name does not match resolver name");
        }
        String fileHash = hashString.getHash().replaceAll("[^A-Za-z0-9_\\-\\.]", "_").toLowerCase();
        String path = FileSystemBackedHashResolver.partition(fileHash);
        return new File(this.storeLocation, FilenameUtils.separatorsToSystem((String)path)).exists();
    }

    @Override
    public HashFileReference lookupByHash(HashFileStore store, HashString fileHash, boolean storeNewHash) {
        File file = this.resolve(fileHash, storeNewHash);
        return new FileBackedHashFileReference(store, file, fileHash);
    }

    public static String partition(String fileHash) {
        StringBuilder path = new StringBuilder();
        String separator = FilenameUtils.separatorsToSystem((String)"/");
        char[] hash = fileHash.toCharArray();
        for (int i = 0; i < hash.length; ++i) {
            char ch = hash[i];
            if (i > 0 && i % 2 == 0 && i <= 10) {
                path.append(separator);
            }
            path.append(ch);
        }
        path.append(".data");
        return path.toString();
    }

    private File resolve(HashString hashString, boolean storeNewHash) {
        if (!this.belongsToUs(hashString)) {
            throw new IllegalArgumentException("HashString name does not match resolver name");
        }
        String fileHash = hashString.getHash().replaceAll("[^A-Za-z0-9_\\-\\.]", "_").toLowerCase();
        String path = FileSystemBackedHashResolver.partition(fileHash);
        File file = new File(this.storeLocation, FilenameUtils.separatorsToSystem((String)path));
        HashString safeHashString = new HashString(hashString.getStoreName(), fileHash);
        if (storeNewHash && this.dao.getHashByIdWithoutFlush(safeHashString.toString()) == null && !this.flags.isInMaintenanceMode()) {
            this.dao.hashCreated(safeHashString, file.length());
        }
        return file;
    }

    public HashString resolve(File file, String theStoreName) {
        String relativePath = this.storeLocation.toURI().relativize(file.toURI()).getPath();
        String convertedPath = this.convertPath(relativePath);
        String hash = convertedPath.replaceAll("/", "");
        HashString hashString = new HashString(theStoreName, hash);
        return hashString;
    }

    private String convertPath(String relativePath) {
        try {
            return relativePath.substring(0, relativePath.indexOf(".data"));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Hash backed filename does not end with .data extension : " + relativePath, e);
        }
    }

    private boolean belongsToUs(HashString hashString) {
        hashString.getStoreName();
        return hashString.isDefaultStore() && "default".equals(this.storeName) || this.storeName.equals(hashString.getStoreName());
    }

    @Override
    public HashString generateHash(InputStream is) throws IOException {
        if ("default".equals(this.storeName)) {
            return new HashString(this.hasher.hash(is));
        }
        return new HashString(this.storeName, this.hasher.hash(is));
    }

    @Override
    public void removeHash(HashFileReference reference) {
        this.dao.hashRemoved(reference.getHash());
        reference.delete();
    }
}

