/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash.impl;

import java.io.IOException;
import java.io.InputStream;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.springframework.beans.factory.InitializingBean;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.BlobBackedHashFileReference;

public class BlobStoreBackedHashResolver
implements FileHashResolver,
InitializingBean {
    private final BlobStore blobStore;
    private final String storeName;
    private final String containerName;
    private final FileHasher hasher;
    private final HashInfoDAO dao;
    private final MaintenanceModeFlags flags;

    public BlobStoreBackedHashResolver(BlobStoreContext context, String prefix, String name, FileHasher hasher, HashInfoDAO dao, MaintenanceModeFlags flags) {
        this.blobStore = context.getBlobStore();
        this.storeName = name;
        this.containerName = prefix + name;
        this.hasher = hasher;
        this.dao = dao;
        this.flags = flags;
    }

    @Override
    public boolean exists(HashString hashString) {
        if (!this.belongsToUs(hashString)) {
            throw new IllegalArgumentException("HashString name does not match resolver name");
        }
        return this.blobStore.blobExists(this.containerName, hashString.getHash());
    }

    @Override
    public BlobBackedHashFileReference lookupByHash(HashFileStore store, HashString hashString, boolean storeNewHash) {
        if (!this.belongsToUs(hashString)) {
            throw new IllegalArgumentException("HashString name does not match resolver name");
        }
        HashString safeHashString = new HashString(hashString.getStoreName(), hashString.getHash());
        if (storeNewHash && this.dao.getHashByIdWithoutFlush(safeHashString.toString()) == null && !this.flags.isInMaintenanceMode()) {
            BlobMetadata metadata = this.blobStore.blobMetadata(this.containerName, hashString.getHash());
            this.dao.hashCreated(safeHashString, metadata == null ? 0L : metadata.getSize());
        }
        return new BlobBackedHashFileReference(store, this.blobStore, this.containerName, hashString);
    }

    private boolean belongsToUs(HashString hashString) {
        return hashString.isDefaultStore() && "default".equals(this.storeName) || this.storeName.equals(hashString.getStoreName());
    }

    @Override
    public HashString generateHash(InputStream is) throws IOException {
        if ("default".equals(this.storeName)) {
            return new HashString(this.hasher.hash(is));
        }
        return new HashString(this.storeName, this.hasher.hash(is));
    }

    @Override
    public void removeHash(HashFileReference reference) {
        this.dao.hashRemoved(reference.getHash());
        reference.delete();
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.blobStore.containerExists(this.containerName)) {
            this.blobStore.createContainerInLocation(null, this.containerName);
        }
    }

    BlobStore getBlobStore() {
        return this.blobStore;
    }

    String getContainerName() {
        return this.containerName;
    }
}

