/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.HashString;

public final class CompositeFileHashResolver
implements FileHashResolver {
    private final Map<String, FileHashResolver> resolvers;
    private final FileHashResolver defaultResolver;

    public CompositeFileHashResolver(Map<String, FileHashResolver> resolvers2) {
        this.resolvers = resolvers2;
        this.defaultResolver = this.resolvers.get("default");
    }

    @Override
    public boolean exists(HashString fileHash) {
        if (fileHash.isDefaultStore()) {
            return this.defaultResolver.exists(fileHash);
        }
        FileHashResolver fileHashResolver = this.resolvers.get(fileHash.getStoreName());
        if (fileHashResolver == null) {
            throw new IllegalArgumentException("No hash resolver recognised hash " + fileHash.toString());
        }
        return fileHashResolver.exists(fileHash);
    }

    @Override
    public HashString generateHash(InputStream is) throws IOException {
        return this.defaultResolver.generateHash(is);
    }

    @Override
    public HashFileReference lookupByHash(HashFileStore store, HashString fileHash, boolean storeNewHash) {
        if (fileHash.isDefaultStore()) {
            return this.defaultResolver.lookupByHash(store, fileHash, storeNewHash);
        }
        FileHashResolver fileHashResolver = this.resolvers.get(fileHash.getStoreName());
        if (fileHashResolver == null) {
            throw new IllegalArgumentException("No hash resolver recognised hash " + fileHash.toString());
        }
        return fileHashResolver.lookupByHash(store, fileHash, storeNewHash);
    }

    @Override
    public void removeHash(HashFileReference reference) {
        this.defaultResolver.removeHash(reference);
    }
}

