/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.warwick.util.csv.CSVLineReader;
import uk.ac.warwick.util.csv.DuplicateResolver;

public final class NamedValueCSVLineReader
implements CSVLineReader<List<String>> {
    private List<String> headers;
    private List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private boolean hasHeaders;
    private boolean firstLine = true;
    private int tableWidth;

    @Override
    public List<String> constructNewObject() {
        return new ArrayList<String>();
    }

    @Override
    public void end(List<String> line) {
        this.tableWidth = Math.max(line.size(), this.tableWidth);
        if (this.hasHeaders && this.firstLine) {
            this.headers = line;
        } else {
            this.data.add(this.toMap(line));
        }
        this.firstLine = false;
    }

    private Map<String, String> toMap(List<String> line) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < line.size(); ++i) {
            String key = this.hasHeaders && i < this.headers.size() ? this.headers.get(i) : "" + i;
            key = this.resolveDuplicateKeys(key, map);
            map.put(key, line.get(i));
        }
        return map;
    }

    private String resolveDuplicateKeys(String tkey, Map<String, String> map) {
        String key;
        String keyCandidate = key = tkey;
        DuplicateResolver<String> resolver = DuplicateResolver.incrementingNumber();
        while (map.containsKey(keyCandidate)) {
            keyCandidate = resolver.getAlternate(key);
        }
        key = keyCandidate;
        return key;
    }

    @Override
    public void setColumn(List<String> line, int col, String text) {
        if (col != line.size()) {
            throw new IllegalArgumentException("setColumn is being called out of order");
        }
        line.add(col, text);
    }

    public boolean isHasHeaders() {
        return this.hasHeaders;
    }

    public void setHasHeaders(boolean hasHeaders) {
        this.hasHeaders = hasHeaders;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    @Override
    public void endData() {
    }
}

