/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import uk.ac.warwick.util.csv.CSVException;
import uk.ac.warwick.util.csv.CSVLineReader;
import uk.ac.warwick.util.csv.CSVLineWriter;

public abstract class AbstractCSVDocument<T> {
    private List<T> lines = new ArrayList<T>();
    private CSVLineWriter<T> writer;
    private CSVLineReader<T> reader;
    private List<String> headerFields = new ArrayList<String>();
    private boolean storeLines = true;
    private boolean headerLine;

    public AbstractCSVDocument(CSVLineWriter<T> theWriter, CSVLineReader<T> theReader) {
        this.writer = theWriter;
        this.reader = theReader;
    }

    public final void addLine(T object) {
        this.lines.add(object);
    }

    public abstract void write(Writer var1) throws IOException;

    public abstract List<T> read(Reader var1) throws IOException, CSVException;

    public abstract int validate(Reader var1) throws IOException, CSVException;

    public final int getNumberOfRows() {
        return this.lines.size();
    }

    public final T getRow(int i) {
        return this.lines.get(i);
    }

    public final void setStoreLines(boolean storeLines) {
        this.storeLines = storeLines;
    }

    protected final List<T> getLines() {
        return this.lines;
    }

    protected final void setLines(List<T> lines) {
        this.lines = lines;
    }

    protected final CSVLineReader<T> getReader() {
        return this.reader;
    }

    protected final void setReader(CSVLineReader<T> reader) {
        this.reader = reader;
    }

    protected final CSVLineWriter<T> getWriter() {
        return this.writer;
    }

    protected final void setWriter(CSVLineWriter<T> writer) {
        this.writer = writer;
    }

    protected final boolean isStoreLines() {
        return this.storeLines;
    }

    public final void addHeaderField(String headerField) {
        this.headerFields.add(headerField);
    }

    protected final List<String> getHeaderFields() {
        return this.headerFields;
    }

    protected final void setHeaderFields(List<String> headerFields) {
        this.headerFields = headerFields;
    }

    public final boolean isHeaderLine() {
        return this.headerLine;
    }

    public final void setHeaderLine(boolean printHeaderLine) {
        this.headerLine = printHeaderLine;
    }
}

