/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring.logging;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;
import uk.ac.warwick.util.core.spring.logging.JULToSLF4JHandler;

public final class RedirectJULToSLF4JContextListener
extends ContextLoaderListener {
    private Handler activeHandler;
    private List<Handler> oldHandlers = Lists.newArrayList();
    private Level handlerLevel = Level.FINE;
    private Level rootLevel = Level.INFO;

    public void contextInitialized(ServletContextEvent event) {
        try {
            JULToSLF4JHandler.getTargetLogger(RedirectJULToSLF4JContextListener.class).info("start(): Redirecting java.util.logging to Log4J...");
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            for (Handler handler : rootLogger.getHandlers()) {
                this.oldHandlers.add(handler);
                rootLogger.removeHandler(handler);
            }
            this.activeHandler = new JULToSLF4JHandler();
            this.activeHandler.setLevel(this.handlerLevel);
            rootLogger.addHandler(this.activeHandler);
            rootLogger.setLevel(this.rootLevel);
            LoggerFactory.getLogger((String)RedirectJULToSLF4JContextListener.class.getName()).info("started: sending JDK log messages to SLF4J");
        }
        catch (Exception exc) {
            JULToSLF4JHandler.getTargetLogger(RedirectJULToSLF4JContextListener.class).error("start() failed", (Throwable)exc);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.removeHandler(this.activeHandler);
        for (Handler oldHandler : this.oldHandlers) {
            rootLogger.addHandler(oldHandler);
        }
        LoggerFactory.getLogger((String)JULToSLF4JHandler.class.getName()).info("stopped");
    }
}

